package net.rmi.rjs.jobs;

import j2d.ShortImageBean;

import java.awt.*;
import java.io.Serializable;
import java.rmi.RemoteException;

public class Fractals {
    public  FractalLogic fractalLogic = new FractalLogic();

    public Fractals() {
    }
    public  ComputeJobs getComputeJobs(Dimension d) {
        ComputeJobs cjs = new ComputeJobs();
        cjs.add(getComputeJob(d.width, d.height));
        cjs.add(getComputeJob(d.width, d.height));
        return cjs;
    }
    
    /* Author = Francisco Castellanos
     * Date = 06/10/05
     * 1. This method creates a ShortImageBean. 
     * 2. It breaks the image into the the number of parts specified.
     * 3. Generates an array of compute jobs based on the number of parts.
     * 4. And creates, populates an returns an instance of ComputeJobs
     */ 
    public ComputeJobs getComputeJobs(Dimension d, int noParts ) {
        
    	ShortImageBean sib = new ShortImageBean(d.width, d.height);
    	ComputeJob[] cj = fractalLogic.TopDownPartition(sib, noParts);
    	//ShortImageBean[] sibs = fractalLogic.TopDownPartition2(sib, noParts);
    	//ComputeJob[] cj = getComputeJob(sibs, d.width, d.height);
    	ComputeJobs cjs = new ComputeJobs();	
    	//System.out.println("Size of Array return by fracntalLogic = " + cj.length);
    	
    	for (int i=0; i < cj.length; i++){
    		
    		cjs.add(cj[i]);
    	}
    	return cjs;
    }
   
    public ComputeJob getComputeJob(final int w, final int h) {
        return new ComputeJob() {
            public Serializable getAnswer() {
                ShortImageBean sib = new ShortImageBean(w, h);
                fractalLogic.mandelbrot(sib.getR(), sib.getG(), sib.getB());
                return sib;
            }
        };
    }
    
    /* Author= Francisco Castellanos
     * Date = 06/10/05
     * 1. This method takes an array of ShortImageBean objects.
     * 2. It takes each image in the array and creates a ComputeJob anonymous object.
     * 3. The object process the image using the mandelbrot method in FractalLogic.
     * 4. It return an array of computable jobs.   
     */
    public ComputeJob[] getComputeJob(final ShortImageBean[] sibs, final int orgWidth, final int orgHeight) {
    	ComputeJob[] jobs = new ComputeJob[sibs.length];
    	for (int i = 0; i < sibs.length; i++){
	    	final ShortImageBean sib = sibs[i];	
	        jobs[i] = new ComputeJob(){  
				public Serializable getAnswer(){
					//System.out.println("Processing piece Image fp=" + fromP + "tp=" + toP); 
					short[][] r = sib.getR();
					short[][] g = sib.getG();
					short[][] b = sib.getB();
					int height = r[0].length;
			        int width = r.length;
					for (int y = 0; y < height; y++){
						for (int x = 0; x < width; x++) {
					          fractalLogic.mandelbrot(x, y, orgWidth, orgHeight, r, g, b);
					    }
			        }
					return sib;
				}
			};
    	}
    	return jobs;
    }
    
    public FractalLogic getFractalLogic() {
        return fractalLogic;
    }

}// End of class Fractals

