package net.rmi.rjs;

// net.rmi.armi.RemoteHelloImplementation;

import futils.Futil;
import net.rmi.armi.HelloWorld;
import utils.SystemUtils;

import java.io.File;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

// todo implement the put and get features of the RMIFileServerImplementation and
// test them with remote method invocation.
// due next week.

public class RMIFileServerImplementation
        extends UnicastRemoteObject
        implements RMIFileServerInterface {
    HelloWorld hw = new HelloWorld();
    public static String REMOTE_NAME = "RmiFileServerMain";

    public RMIFileServerImplementation()
            throws RemoteException {
    }

    public void testGetMsg() throws RemoteException {
        hw.testGetMsg();
    }

    public String getMsg() throws RemoteException {
        return hw.getMsg();
    }

    public void putFile(String fileName, byte data[]) throws RemoteException {
        if (data == null) System.out.println("Data=null!");
        File f = new File(SystemUtils.getUserHome() +
                SystemUtils.getDirectorySeparator() +
                fileName);
        Futil.writeBytes(f, data);
        System.out.println("wrote file:" + f.getAbsolutePath());
    }

    public byte[] getFile(String fileName) throws RemoteException {
        File f = new File(SystemUtils.getUserHome() +
                SystemUtils.getDirectorySeparator() +
                fileName);
        return Futil.readBytes(f);
    }
}

// use the rmic compiler to create a stub
// rmic -v1.2 -d . net.rmi.armi.RemoteHelloImplementation
