package net.compute;

/**
 * Created by
 * User: lyon
 * Date: Sep 3, 2003
 * Time: 11:17:45 AM
 *
 */

import java.io.*;

/**
 *  Use the reloader to get the bytecode from
 * a file for a class. Then, transmit the class byte
 * codes to the computation server. Use the
 * Reloader on the computation server to define the
 * class. Then compute the computation.
 * Send the answer back to the compute client.
 * Finally, set the remote reloader to null and
 * close the connections.
 */

public class ReLoader extends ClassLoader {

    private String classPath;

    public ReLoader() {
        classPath = null;
    }

    public ReLoader(String classPath) {

        this.classPath = classPath;
    }



    public Class defineClass(byte b[], String className) {
        return super.defineClass(className, b, 0, b.length);
    }

    public synchronized Class loadClass(String className,
                                        boolean resolveIt)
            throws ClassNotFoundException {

        Class result;
        byte classData[];

        // Check the loaded class cache
        result = findLoadedClass(className);
        if (result != null) {
            // Return a cached class
            System.out.println("The class has already been loaded");
            return result;
        }

        // If Spoofed, don't delegate
        // result is 0 if strings are equal.
        if (className.compareTo("Spoofed") != 0) {

            // Check with the system class loader
            try {
                return loadWithSystemClassLoader(className);
            } catch (ClassNotFoundException e) {
                System.out.println("unable to load with system class loader...");
            }
        }

        // Don't attempt to load a system file except through
        // the primordial class loader
        // for example, java.lang.String
        if (className.startsWith("java.")) {
            throw new ClassNotFoundException();
        }

        // Try to load it from the classPath directory.
        classData = getByteCodes(className);
        System.out.println("classData has " + classData.length + " bytes");
        if (classData == null) {
            System.out.println("Reloader - Can't load class: "
                    + className);
            throw new ClassNotFoundException();
        }

        System.out.println("defining class..." + className);
        try {
            result = defineClass(null, classData, 0,
                    classData.length);
        } catch (ClassFormatError classFormatError) {
            classFormatError.printStackTrace();
            System.out.println("class format error!!");
            System.exit(0);
        }
        System.out.println("It worked!!! newly defined class:" + result);
        if (result == null) {
            System.out.println("Reloader - Class format error: "
                    + className);
            throw new ClassFormatError();
        }

        if (resolveIt) {
            resolveClass(result);
        }

        // Return class from classPath directory
        return result;
    }

    private Class loadWithSystemClassLoader(String className)
            throws ClassNotFoundException {
        return super.findSystemClass(className);
    }

    public byte[] getByteCodes(String typeName) {

        FileInputStream fis;
        String fileName = classPath + File.separatorChar
                + typeName.replace('.', File.separatorChar)
                + ".class";

        try {
            fis = new FileInputStream(fileName);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }

        BufferedInputStream bis = new BufferedInputStream(fis);

        ByteArrayOutputStream baos = new ByteArrayOutputStream();

        try {
            int c = bis.read();
            while (c != -1) {
                baos.write(c);
                c = bis.read();
            }
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }

        return baos.toByteArray();
    }

    public static void main(String[] args) {

        String classPath = "C:\\lyon\\tomcat\\common\\classes";
        String className1 = "net.compute.ReLoader";

        try {

            ReLoader rl =
                    new ReLoader(classPath);
            System.out.println("loading class...");
            rl.loadClass(className1);
            byte b[] = rl.getByteCodes(className1);
            print(b);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }


    }

    public static void print(byte b[]) {
        for (int i = 0; i < b.length; i++) {
            System.out.print((char) (0xff & b[i]));
            if ((i % 10) == 0) System.out.println();
        }
    }

    public static void reloadClasses(String classPath, String className)
            throws ClassNotFoundException {
        System.out.println("loading classpath:" + classPath
                + "loading class name:" + className + "------");
        ReLoader rl =
                new ReLoader(classPath);
        System.out.println("loading class...");
        Class c = rl.loadClass(className);
        System.out.println("class returned:" + c);
        //((Runnable) c.newInstance()).run();
    }
}

