package math.fourierTransforms.pfa;

import gui.In;
import utils.StopWatch;


//Title:        1-d mixed radix Inverse FFT.
//Version:
//Copyright:    Copyright (c) 1998
//Author:       Dongyan Wang
//Company:      University of Wisconsin-Milwaukee.
//Description:
//              According to the definition of the inverse fourier transform,
//              We can use FFT to calculate the IFFT,
//                 IFFT(x) = 1/N * conj(FFT(conj(x)).
//
//              . Change the sign of the imaginary part of the FFT input.
//              . Calculate the FFT.
//              . Change the sign of the imaginary part of the FFT output.
//              . Scale the output by 1/N.
//


public class IFFTPfa1d {
    int N;

    // Constructor: IFFT of Complex data.
    public IFFTPfa1d(int N) {
        this.N = N;
    }

    public void ifft(float inputRe[], float inputIm[]) {

//  Change the sign of the imaginary part of the FFT input.
        for (int i = 0; i < N; i++)
            inputIm[i] = -inputIm[i];

//  Calculate the FFT.
        FFTPfa1d fft1 = new FFTPfa1d(N);
        fft1.fft(inputRe, inputIm);

//  Change the sign of the imaginary part of the FFT output.
//  Scale output by 1/N.

        for (int i = 0; i < inputRe.length; i++) {
            inputRe[i] = inputRe[i] / N;
            inputIm[i] = -inputIm[i] / N;
        }
    }

    public static void main(String[] args) {
        do
            testPfa(In.getInt("select an n > 1"));
        while (In.getBoolean("again?"));
    }

    public static void testPfa(int n) {
        float re[] = new float[n];
        float im[] = new float[n];
        for (int i = 0; i < im.length; i++) {
            re[i] = i;
        }
        FFTPfa1d fft1 = new FFTPfa1d(re.length);
        IFFTPfa1d ifft1 = new IFFTPfa1d(re.length);
        StopWatch t = new StopWatch();
        t.start();
        fft1.fft(re, im);
        t.stop();
        System.out.println("time for forward PFA n="+n);
        t.report();
        t.start();
        ifft1.ifft(re, im);
        System.out.println("time for backward PFA n=" + n);
        t.report();
        //print(re);
    }

    public static void print(float f[]) {
        for (int i = 0; i < f.length; i++)
            System.out.println(f[i]);
    }
}
