package math.fourierTransforms.fixPoint;


public class IntegerDFT {

    private final static int scaleFactor = 1000;
    private final static int PI = scale(3.1415926535);
    private static int r_data[],i_data[];

    public IntegerDFT(int r_data[], int i_data[]) {
        IntegerDFT.r_data = r_data;
        IntegerDFT.i_data = i_data;

    }


    private int sin(int d) {
        double v = Math.sin(d / scaleFactor);
        return scale(v);
    }

    private int cos(int d) {
        double v = Math.cos(d / (scaleFactor));
        return scale(v);
    }

    private final static int scale(double v) {
        return (int) (v * scaleFactor);
    }

    // todo, decide if you need this function.
    // if you have a fixed input, then you know how
    // many bits you need apriori...i.e. 256 samples
    // returns 8 as an answer.
    public static int log2(int n) {
        return (int) (Math.log(n) / Math.log(2.0));
    }


    private void normalizeData() {
        int N = r_data.length;
        for (int k = 0; k < N; k++) {
            r_data[k] /= N;
            i_data[k] /= N;
        }

    }

    // assume that r_data and i_data are
    // set. Also assume that the real
    // value is to be returned
    public int[] idft(int v[]) {
        int N = r_data.length;
        int twoPiOnN = 2 * PI / N;
        int twoPikOnN;
        int twoPijkOnN;
        for (int k = 0; k < N; k++) {
            twoPikOnN = twoPiOnN * k;
            for (int j = 0; j < N; j++) {
                twoPijkOnN = twoPikOnN * j;
                v[k] += r_data[j] * cos(twoPijkOnN)
                        - i_data[j] * sin(twoPijkOnN);

            }
        }
        return v;
    }


    public static void testDFT() {

        int N = 16;
        int r_data[] = new int[N];
        int i_data[] = new int[N];

        for (int j = 0; j < N; j++)
            r_data[j] = j ;
        IntegerDFT f = new IntegerDFT(r_data,i_data);


        // take dft
        f.dft(r_data);
        int v[] = f.idft(new int[N]);
        System.out.println("j\tx1[j]\tre[j]\tim[j]\t v[j]");
        for (int j = 0; j < N; j++)
            System.out.println(j + "\t" +
                    r_data[j] + "\t" +
                    IntegerDFT.r_data[j] + "\t" +
                    IntegerDFT.i_data[j] + "\t" +
                    v[j]/(scaleFactor*scaleFactor));

    }

    public static void main(String args[]) {
        testDFT();

    }

    public void dft(int v[]) {
        int N = v.length;

        System.out.println("N=" + N);
        int twoPikOnN;
        int twoPijkOnN;

        // how many bits do we need?
        N = log2(N);
        //Truncate input data to a power of two
        // length = 2**(number of bits).
        N = 1 << N;

        int twoPiOnN = 2 * PI / N;

        // We truncate to a power of two so that
        // we can compare execution times with the FFT.
        // DFT generally does not need to truncate its input.

        r_data = new int[N];
        i_data = new int[N];


        System.out.println("Executing DFT on " + N + " points...");

        for (int k = 0; k < N; k++) {

            twoPikOnN = twoPiOnN * k;


            for (int j = 0; j < N; j++) {
                twoPijkOnN = twoPikOnN * j;
                r_data[k] += v[j] * cos(twoPijkOnN);
                i_data[k] -= v[j] * sin(twoPijkOnN);
            }
        }
        normalizeData();
    }


}
