package math.approximations;

import math.numerics.Function;

/**
 * Class CurveFitting defines various curve fitting algorithms inluding linear regression.
 *
 * This class cannot be subclassed or instantiated because all methods are static.
 *
 * @author Wolfgang Christian
 */

public class CurveFitting {
  private CurveFitting() {} // prohibit instantiation because all methods are static

  /**
   * Computes the linear regression for the given data.
   * @param xpoints double[]
   * @param ypoints double[]
   * @return Function  the linear regression function
   */
  public static Function LinearRegression(double[] xpoints,  double[] ypoints) {
  double xBar_yBar = 0;
  double xBar = 0;
  double yBar = 0;
  double x2Bar = 0;
  double x = 0;
  double y = 0;
  for (int i = 0; i < xpoints.length; i++) {
    x = xpoints[i];
    y = ypoints[i];
    xBar_yBar += x * y;
    xBar += x;
    yBar += y;
    x2Bar += x * x;
  }
  int n = xpoints.length;
  xBar_yBar = xBar_yBar / n;
  xBar = xBar / n;
  yBar = yBar / n;
  x2Bar = x2Bar / n;
  double deltaX2 = x2Bar - xBar * xBar;
  final double m = (xBar_yBar - xBar * yBar) / deltaX2;
  final double b = yBar - m * xBar;
  return new Function() {
    public double evaluate(double x) {
      return m * x + b;
    }
  };
}


}
