package j3d.utils.sceneGraphInspector;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.SceneGraphObject;
import javax.swing.*;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import java.util.ArrayList;

public class SceneGraphTreeModel implements TreeModel {

    private SceneGraphNode root;
    private EventListenerList listenerList = new EventListenerList();

    public SceneGraphTreeModel() {
        root = null;
    }

    public void addTreeModelListener(TreeModelListener l) {
        listenerList.add(TreeModelListener.class, l);
    }

    public static JScrollPane buildPane(BranchGroup bg) {
        SceneGraphTreeModel model = new SceneGraphTreeModel();
        model.setRoot(new SceneGraphNode(null, bg));
        return new JScrollPane(new JTree(model));
    }

    protected void fireTreeStructureChanged(Object oldRoot) {
        TreeModelEvent event = new TreeModelEvent(this, new Object[]{oldRoot});
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2)
            ((TreeModelListener) listeners[i + 1]).treeStructureChanged(event);
    }

    public Object getChild(Object parent, int index) {
        SceneGraphNode v = (SceneGraphNode) parent;
        ArrayList children = v.getChildren();
        Object object = v.getValue();

        Child child = (Child) children.get(index);
        SceneGraphObject sgo = child.sgo;
        return
                new SceneGraphNode(//sgo == null ?
                        child.role //:
                        , //SceneGraphNode.shortClassName(sgo.getClass()),
                        sgo);
    }

    public int getChildCount(Object parent) {
        SceneGraphNode v = (SceneGraphNode) parent;
        return v.getChildren().size();
    }

    public int getIndexOfChild(Object parent, Object child) {
        int n = getChildCount(parent);
        for (int i = 0; i < n; i++)
            if (getChild(parent, i).equals(child)) return i;
        return -1;
    }

    public Object getRoot() {
        return root;
    }

    public boolean isLeaf(Object node) {
        return getChildCount(node) == 0;
    }

    public void removeTreeModelListener(TreeModelListener l) {
        listenerList.remove(TreeModelListener.class, l);
    }

    public void setRoot(SceneGraphNode v) {
        SceneGraphNode oldRoot = v;
        root = v;
        fireTreeStructureChanged(oldRoot);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

}
