package j3d.utils.propertyEditors;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.lang.reflect.Method;


public class PECheckBoxBuilder extends PEAbstractButtonBuilder {

    public PECheckBoxBuilder(final Object obj, String name) {
        super(obj, name, new JCheckBox(name));
    }

    public void addEventListener(final Object obj, final Method writer) {
        button.addChangeListener(new ChangeListener() {
            public void stateChanged(ChangeEvent e) {
                writeToObject(obj, writer, new Boolean(button.isSelected()));
            }
        });
    }

    public void setSwingJComponentFromObject(final Object obj, final Method reader) {
        button.setSelected(((Boolean) readFromObject(obj, reader)).booleanValue());
    }

}