package j3d.utils;

/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */

import gui.run.IntChooser;
import gui.run.IntEvent;
import gui.run.IntListener;

import javax.media.j3d.TextureAttributes;
import javax.swing.*;
import javax.vecmath.Color4f;


public class TextureAttributesEditor extends Box
        implements Java3DExplorerConstants {

    // TextureAttributes
    TextureAttributes textureAttr;
    float transparency;
    int mode;
    int pcMode;
    Color4f blendColor = new Color4f();

    public TextureAttributesEditor(TextureAttributes init) {
        super(BoxLayout.Y_AXIS);
        textureAttr = init;
        mode = textureAttr.getTextureMode();
        pcMode = textureAttr.getPerspectiveCorrectionMode();
        textureAttr.getTextureBlendColor(blendColor);

        String[] modeNames = {
            "REPLACE",
            "MODULATE",
            "DECAL",
            "BLEND",
        };
        int[] modeValues = {
            TextureAttributes.REPLACE,
            TextureAttributes.MODULATE,
            TextureAttributes.DECAL,
            TextureAttributes.BLEND,
        };

        IntChooser modeChooser = new IntChooser("Mode:",
                modeNames, modeValues, mode);
        modeChooser.addIntListener(new IntListener() {
            public void intChanged(IntEvent event) {
                mode = event.getValue();
                textureAttr.setTextureMode(mode);
            }
        });
        add(modeChooser);

        Color4fEditor blendColorEditor = new Color4fEditor("Blend Color",
                blendColor);
        blendColorEditor.addColor4fListener(new Color4fListener() {
            public void colorChanged(Color4fEvent event) {
                event.getValue(blendColor);
                textureAttr.setTextureBlendColor(blendColor);
            }
        });
        add(blendColorEditor);

        String[] pcModeNames = {
            "NICEST",
            "FASTEST",
        };
        int[] pcModeValues = {
            TextureAttributes.NICEST,
            TextureAttributes.FASTEST,
        };

        IntChooser pcModeChooser = new IntChooser("Perspective Correction:",
                pcModeNames, pcModeValues, pcMode);
        pcModeChooser.addIntListener(new IntListener() {
            public void intChanged(IntEvent event) {
                pcMode = event.getValue();
                textureAttr.setPerspectiveCorrectionMode(pcMode);
            }
        });
        add(pcModeChooser);

    }
}
