package j3d.utils;

/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */

import com.sun.j3d.utils.image.TextureLoader;
import gui.layouts.LeftAlignComponent;
import gui.run.IntChooser;
import gui.run.IntEvent;
import gui.run.IntListener;
import utils.ResourceManager;

import javax.media.j3d.Appearance;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.swing.*;
import javax.vecmath.Color4f;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;


public class Texture2DEditor extends Box implements
        Java3DExplorerConstants {

    Appearance appearance;
    Texture2D texture;
    String imageFile;
    String[] imageNames;
    String[] imageFileNames;
    int imageIndex;
    TextureLoader texLoader;
    int width;
    int height;
    int format;
    boolean enable;
    Color4f boundaryColor = new Color4f();
    int boundaryModeS;
    int boundaryModeT;
    int minFilter;
    int magFilter;
    int mipMapMode;


    public Texture2DEditor(Appearance app,
                           String[] texImageNames, String[] texImageFileNames, int texImageIndex,
                           boolean texEnable, int texBoundaryModeS, int texBoundaryModeT,
                           int texMinFilter, int texMagFilter, int texMipMapMode,
                           Color4f texBoundaryColor) {

        super(BoxLayout.Y_AXIS);

        this.appearance = app;
        // TODO: make deep copies?
        this.imageNames = texImageNames;
        this.imageFileNames = texImageFileNames;
        this.imageIndex = texImageIndex;
        this.imageFile = texImageFileNames[texImageIndex];

        this.enable = texEnable;
        this.mipMapMode = texMipMapMode;
        this.boundaryModeS = texBoundaryModeS;
        this.boundaryModeT = texBoundaryModeT;
        this.minFilter = texMinFilter;
        this.magFilter = texMagFilter;
        this.boundaryColor.set(texBoundaryColor);

        // set up the initial texture
        setTexture();

        JCheckBox texEnableCheckBox = new JCheckBox("Enable Texture");
        texEnableCheckBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                enable = ((JCheckBox) e.getSource()).isSelected();
                // workaround for bug
                // should just be able to
                // texture.setEnable(texEnable);
                // instead we have to:
                setTexture();
            }
        });

        // add the checkbox to the panel
        add(new LeftAlignComponent(texEnableCheckBox));

        IntChooser imgChooser = new IntChooser("Image:", imageNames);
        imgChooser.setValue(imageIndex);
        imgChooser.addIntListener(new IntListener() {
            public void intChanged(IntEvent event) {
                imageIndex = event.getValue();
                imageFile = imageFileNames[imageIndex];
                setTexture();
            }
        });
        add(imgChooser);

        // texture boundaries
        String[] boundaryNames = {
            "WRAP",
            "CLAMP",
        };
        int[] boundaryValues = {
            Texture.WRAP,
            Texture.CLAMP,
        };

        // texture boundary S
        IntChooser bndSChooser = new IntChooser("Boundary S Mode:",
                boundaryNames, boundaryValues);
        bndSChooser.setValue(texBoundaryModeS);
        bndSChooser.addIntListener(new IntListener() {
            public void intChanged(IntEvent event) {
                int value = event.getValue();
                boundaryModeS = value;
                setTexture();
            }
        });
        add(bndSChooser);

        // texture boundary T
        IntChooser bndTChooser = new IntChooser("Boundary T Mode:",
                boundaryNames, boundaryValues);
        bndTChooser.setValue(texBoundaryModeT);
        bndTChooser.addIntListener(new IntListener() {
            public void intChanged(IntEvent event) {
                int value = event.getValue();
                boundaryModeT = value;
                setTexture();
            }
        });
        add(bndTChooser);


        // texture min filter
        String[] minFiltNames = {
            "FASTEST",
            "NICEST",
            "BASE_LEVEL_POINT",
            "BASE_LEVEL_LINEAR",
            "MULTI_LEVEL_POINT",
            "MULTI_LEVEL_LINEAR",
        };
        int[] minFiltValues = {
            Texture.FASTEST,
            Texture.NICEST,
            Texture.BASE_LEVEL_POINT,
            Texture.BASE_LEVEL_LINEAR,
            Texture.MULTI_LEVEL_POINT,
            Texture.MULTI_LEVEL_LINEAR,
        };

        // min filter
        IntChooser minFiltChooser = new IntChooser("Min Filter:",
                minFiltNames, minFiltValues);
        minFiltChooser.setValue(minFilter);
        minFiltChooser.addIntListener(new IntListener() {
            public void intChanged(IntEvent event) {
                int value = event.getValue();
                minFilter = value;
                setTexture();
            }
        });
        add(minFiltChooser);

        // texture mag filter
        String[] magFiltNames = {
            "FASTEST",
            "NICEST",
            "BASE_LEVEL_POINT",
            "BASE_LEVEL_LINEAR",
        };
        int[] magFiltValues = {
            Texture.FASTEST,
            Texture.NICEST,
            Texture.BASE_LEVEL_POINT,
            Texture.BASE_LEVEL_LINEAR,
        };

        // mag filter
        IntChooser magFiltChooser = new IntChooser("Mag Filter:",
                magFiltNames, magFiltValues);
        magFiltChooser.setValue(magFilter);
        magFiltChooser.addIntListener(new IntListener() {
            public void intChanged(IntEvent event) {
                int value = event.getValue();
                magFilter = value;
                setTexture();
            }
        });
        add(magFiltChooser);

        // texture mipmap mode
        String[] mipMapNames = {
            "BASE_LEVEL",
            "MULTI_LEVEL_MIPMAP",
        };
        int[] mipMapValues = {
            Texture.BASE_LEVEL,
            Texture.MULTI_LEVEL_MIPMAP,
        };

        // mipMap mode
        IntChooser mipMapChooser = new IntChooser("MipMap Mode:",
                mipMapNames, mipMapValues);
        mipMapChooser.setValue(mipMapMode);
        mipMapChooser.addIntListener(new IntListener() {
            public void intChanged(IntEvent event) {
                int value = event.getValue();
                mipMapMode = value;
                setTexture();
            }
        });
        add(mipMapChooser);

        Color4fEditor boundaryColorEditor = new Color4fEditor("Boundary Color",
                boundaryColor);
        boundaryColorEditor.addColor4fListener(new Color4fListener() {
            public void colorChanged(Color4fEvent event) {
                event.getValue(boundaryColor);
                setTexture();
            }
        });
        add(boundaryColorEditor);
    }


    // create a Texture2D using the current values from the GUI
    // and attach it to the appearance
    void setTexture() {
        // set up the image using the TextureLoader
        ResourceManager rm = ResourceManager.getResourceManager();
        File f = rm.getImageFile(imageFile);
        java.net.URL imageURL = null;
        try {
            imageURL = f.toURL();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }

        int flags;
        if (mipMapMode == Texture.BASE_LEVEL) {
            flags = 0;
        } else {
            flags = TextureLoader.GENERATE_MIPMAP;
        }
        texLoader = new TextureLoader(imageURL,
                new String("RGBA"),
                flags, this);

        // We could create texture from image
        //
        // Get the image from the loader.  We need an image which
        // has power of two dimensions, so we'll get the unscaled image,
        // figure out what the scaled size should be and then get a scale
        // image
        //ImageComponent2D unscaledImage = texLoader.getImage();
        //int width = unscaledImage.getWidth();
        //int height = unscaledImage.getWidth();
        //
        // scaled values are next power of two greater than or equal to
        // value
        //texWidth = powerOfTwo(width);
        //texHeight = powerOfTwo(height);
        //
        // rescale the image if necessary
        //ImageComponent2D texImage;
        //if ((texWidth == width) && (texHeight == height)) {
        //    texImage = unscaledImage;
        //} else {
        //    texImage = texLoader.getScaledImage(texWidth, texHeight);
        //}
        //texFormat = Texture.RGB;
        //texture = new Texture2D(texMipMapMode, texFormat, texWidth,
        //	texHeight);
        //texture.setImage(0, texImage);

        // instead we'll just get get the texture from loader
        texture = (Texture2D) texLoader.getTexture();

        texture.setBoundaryColor(boundaryColor);
        texture.setBoundaryModeS(boundaryModeS);
        texture.setBoundaryModeT(boundaryModeT);
        texture.setEnable(enable);
        texture.setMinFilter(minFilter);
        texture.setMagFilter(magFilter);

        // Set the capabilities to enable the changable attrs
        texture.setCapability(Texture.ALLOW_ENABLE_WRITE);
        texture.setCapability(Texture.ALLOW_IMAGE_WRITE);

        // connect the new texture to the appearance
        appearance.setTexture(texture);
    }

}
