package j3d.utils;

/*
      @(#)ColoringAttributesEditor.java 1.2 01/08/01 11:02:12

***************************************************************
"Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

-Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

-Redistribution in binary form must reproduce the above copyright notice, this
list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

Neither the name of Sun Microsystems, Inc. or the names of contributors may be
used to endorse or promote products derived from this software without
specific prior written permission.

This software is provided "AS IS," without a warranty of any kind. ALL
EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

You acknowledge that Software is not designed,licensed or intended for use in
the design, construction, operation or maintenance of any nuclear facility."

****************************************************************************
*/

import gui.run.IntChooser;
import gui.run.IntEvent;
import gui.run.IntListener;

import javax.media.j3d.ColoringAttributes;
import javax.swing.*;
import javax.vecmath.Color3f;


public class ColoringAttributesEditor extends Box implements
        Java3DExplorerConstants {

    ColoringAttributes coloringAttr;
    Color3f color = new Color3f();
    int coloringShadeModel;

    public ColoringAttributesEditor(ColoringAttributes init) {
        super(BoxLayout.Y_AXIS);
        coloringAttr = init;
        coloringAttr.getColor(color);
        coloringShadeModel = coloringAttr.getShadeModel();

        String[] shadeNames = {
            "SHADE_FLAT",
            "SHADE_GOURAUD",
            "NICEST",
            "FASTEST"
        };
        int[] shadeValues = {
            ColoringAttributes.SHADE_FLAT,
            ColoringAttributes.SHADE_GOURAUD,
            ColoringAttributes.NICEST,
            ColoringAttributes.FASTEST
        };

        IntChooser shadeChooser = new IntChooser("Shade model:",
                shadeNames, shadeValues, coloringShadeModel);
        shadeChooser.addIntListener(new IntListener() {
            public void intChanged(IntEvent event) {
                int value = event.getValue();
                coloringAttr.setShadeModel(value);
            }
        });
        add(shadeChooser);

        Color3fEditor colorEditor = new Color3fEditor("Color", color);
        colorEditor.addColor3fListener(new Color3fListener() {
            public void colorChanged(Color3fEvent event) {
                event.getValue(color);
                coloringAttr.setColor(color);
            }
        });
        add(colorEditor);
    }

}
