/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j3d.polyViewer.vec3;



/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 2, 2005
 * <p/>
 * Time: 4:02:56 AM
 */
public class Mobius implements Vec3FunctionInterface {
    public Mobius() {

    }

    /*
    x=cos(u)+v*cos(u/2)*cos(u)
    y=sin(u)+v*cos(u/2)*sin(u)
    z=v*sin(u/2)


Try these values.

u = {0,2 Pi}, v = {-0.3,0.3}
    */
    public Vec3 getPolarVec3(double r1,
                             double theta1,
                             double r2,
                             double theta2) {
        //r1 ranges from 0 to 1. want it to range from
        // -1 to 1.
        r1 = (r1 + r2 * Math.cos(theta2));
        r1 = r1 * 2 - 1;
        theta1 = theta1 * 2;
        double x, y, z;
        x = cos(theta1) + r1 * cos(theta1 / 2) * cos(theta1);
        y = sin(theta1) + r1 * cos(theta1 / 2) * sin(theta1);
        z = r1 * sin(theta1 / 2);
        return new Vec3((float) x,
                (float) y,
                (float) z);
    }

    public static final double sin(double theta) {
        return Math.sin(theta);
    }

    public static final double cos(double theta) {
        return Math.cos(theta);
    }

    public String toString() {
        return getClass().getName();
    }
}
