/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j3d.polyViewer.vec3;



/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 2, 2005
 * <p/>
 * Time: 4:02:56 AM
 */
public class MessedUp
        implements Vec3FunctionInterface {
    double sqrt_2 = Math.sqrt(2);

    public MessedUp() {

    }

    /*
    here is my second attempt
    x = (a+cos(uu/2)*sin(vv)-sin(uu/2)*sin(2*vv))*cos(uu)

    y = (a+cos(uu/2)*sin(vv)-sin(uu/2)*sin(2*vv))*sin(uu)

    z = sin(uu/2)*sin(vv)+cos(uu/2)*sin(2*vv)
    #declare vmin  = 0         //Endpoints in the
#declare vmax  = 2*pi         //parametric rectangle.
#declare umin  =  -pi/4           //I.e. min and max uu and vv
#declare umax  =  3*pi/2

    */
    // uu ranges from 0 to 2*PI, but want -PI/4...3*PI/2
    double umin = -Math.PI / 4;
    double umax = 3 * Math.PI / 2;

    public Vec3 getPolarVec3Old(double r1,
                                double theta1,
                                double r2,
                                double theta2) {
        double a = (r1 + r2);

        double x, y, z;
        theta1 = theta1 / 2 * Math.PI;  //now uu ranges from 0 to 1;
        theta1 = (1 - theta1) * umin + theta1 * umax;
        x = (a + cos(theta1 / 2) * sin(theta2) - sin(theta1 / 2) * sin(2 * theta2)) * cos(theta1);

        y = (a + cos(theta1 / 2) * sin(theta2) - sin(theta1 / 2) * sin(2 * theta2)) * sin(theta1);

        z = sin(theta1 / 2) * sin(theta2) + cos(theta1 / 2) * sin(2 * theta2);
        return new Vec3((float) x,
                (float) y,
                (float) z);

    }

    /*
    x = cos(u)*(cos(u/2)*(sqrt_2+cos(v))+(sin(u/2)*sin(v)*cos(v)))


    y = sin(u)*(cos(u/2)*(sqrt_2+cos(v))+(sin(u/2)*sin(v)*cos(v)))


    z = -1*sin(u/2)*(sqrt_2+cos(v))+cos(u/2)*sin(v)*cos(v)

    */
    // I think the ranges on this are wrong...hmm.
    public Vec3 getPolarVec3(double r1,
                             double theta1,
                             double r2,
                             double theta2) {
        //r1 ranges from 0 to 1. want it to range from
        // -1 to 1.
        /*
        r1 = (r1 + r2 * Math.cos(theta2));
        r1 = r1 *2 - 1;
        theta1 = theta1*2;
        */
        theta1 = theta1 / 2 * Math.PI;  //now uu ranges from 0 to 1;
        theta1 = (1 - theta1) * umin + theta1 * umax;
        double x, y, z;
        x = cos(theta1) * (cos(theta1 / 2) *
                (sqrt_2 + cos(theta2)) + (sin(theta1 / 2) *
                sin(theta2) *
                cos(theta2)));


        y = sin(theta1) * (cos(theta1 / 2) *
                (sqrt_2 + cos(theta2)) + (sin(theta1 / 2) *
                sin(theta2) *
                cos(theta2)));


        z = -1 * sin(theta1 / 2) * (sqrt_2 + cos(theta2)) +
                cos(theta1 / 2) * sin(theta2) * cos(theta2);

        return new Vec3((float) x,
                (float) y,
                (float) z);
    }

    public static final double sin(double theta) {
        return Math.sin(theta);
    }

    public static final double cos(double theta) {
        return Math.cos(theta);
    }

    public String toString() {
        return getClass().getName();
    }
}
