package j3d.examples.transforms;

import j3d.utils.sceneGraphBuilderUtils.ControlledUniverse;
import j3d.utils.sceneGraphBuilderUtils.ETransformGroup;
import j3d.utils.sceneGraphBuilderUtils.SGBuilder;
import j3d.utils.sceneGraphBuilderUtils.Window;

import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.swing.*;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import java.awt.*;

public class TransformDemo extends ControlledUniverse {

    protected int radius = 50;
    protected BoundingSphere boundingSphere =
            new BoundingSphere(new Point3d(), radius);

    public TransformDemo() {
        JTabbedPane controlsPanes = new JTabbedPane();
        BranchGroup scene = sceneGraph(controlsPanes);
        addBranchGraph(scene);
        new Window("Transform Demo", getCanvas(), controlsPanes, scene);
        positionTheViewingPlatform(new Vector3d(0, 0, 70));
    }

    protected BranchGroup cones(Box horizontalConePane, Box verticalConePane) {
        Node node = ETransformGroup.rotate(null,
                SGBuilder.cone("Horizontal cone", 4, 20),
                ETransformGroup.Z,
                Math.PI / 2);
        ETransformGroup
                tg = ETransformGroup.controlledSubgraph(horizontalConePane,
                        "Horizontal cone",
                        new Node[]{node},
                        false);
        BranchGroup bg = SGBuilder.newBranchGroup("Cones", tg);

        tg = ETransformGroup
                .controlledSubgraph(verticalConePane,
                        "Vertical cone",
                        new Node[]{SGBuilder.cone("Vertical cone", 4, 20)},
                        false);
        bg.addChild(tg);

        return bg;
    }

    public static ETransformGroup lighting(Box lightingPane) {
        BoundingSphere bounds = new BoundingSphere(new Point3d(), 100);
        Node[] lights = new Node[]{
            SGBuilder.directionalLight("Blue light",
                    new Color3f(Color.blue),
                    new Vector3f(1, 0, 0),
                    bounds),
            SGBuilder.directionalLight("Red light",
                    new Color3f(Color.red),
                    new Vector3f(-1, 0, 0),
                    bounds),
            SGBuilder.directionalLight("Yellow light",
                    new Color3f(Color.yellow),
                    new Vector3f(0, 1, 0),
                    bounds),
            SGBuilder.directionalLight("Green light",
                    new Color3f(Color.green),
                    new Vector3f(0, 0, 1),
                    bounds)};
        return ETransformGroup.controlledSubgraph(lightingPane, "Lighting",
                lights, false);
    }

    public static void main(String[] args) {
        new TransformDemo();
    }

    protected BranchGroup sceneGraph(JTabbedPane controlPanes) {
        Box hierarchicalPane = Box.createVerticalBox();
        Box combinedPane = Box.createVerticalBox();
        Box lightingPane = Box.createVerticalBox();
        Box horizontalConePane = Box.createVerticalBox();
        Box verticalConePane = Box.createVerticalBox();

        addPanes(controlPanes,
                hierarchicalPane,
                combinedPane,
                lightingPane,
                horizontalConePane,
                verticalConePane);

        ETransformGroup
                tg = ETransformGroup
                .controlledSubgraph(combinedPane,
                        "Cones and axes",
                        new Node[]{cones(horizontalConePane,
                                verticalConePane),
                                   SGBuilder.axes(radius)},
                        false);

        tg = ETransformGroup.controlledSubgraph(hierarchicalPane,
                "Lighting, cones, and axes",
                new Node[]{lighting(lightingPane), tg},
                true);

        BranchGroup scene = SGBuilder.newBranchGroup("SceneGraph", tg);

        scene.addChild(SGBuilder.background(preDawn,
                SGBuilder.greatCircleAxes(),
                boundingSphere));

        scene.compile();
        return scene;
    }

    private static void addPanes(JTabbedPane controlPanes, Box hierarchicalPane, Box combinedPane, Box lightingPane, Box horizontalConePane, Box verticalConePane) {
        controlPanes.add("Hierarchical transforms", hierarchicalPane);
        controlPanes.add("Single transform", combinedPane);
        controlPanes.add("Lighting", lightingPane);
        controlPanes.add("Horizontal Cone", horizontalConePane);
        controlPanes.add("Vertical Cone", verticalConePane);
    }

}