package j3d.examples.transforms;

/*
      %Z%%M% %I% %E% %U%

***************************************************************
"Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

-Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

-Redistribution in binary form must reproduce the above copyright notice, this
list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

Neither the name of Sun Microsystems, Inc. or the names of contributors may be
used to endorse or promote products derived from this software without
specific prior written permission.

This software is provided "AS IS," without a warranty of any kind. ALL
EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

You acknowledge that Software is not designed,licensed or intended for use in
the design, construction, operation or maintenance of any nuclear facility."

****************************************************************************
*/

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import gui.run.FloatEvent;
import gui.run.FloatLabelJSlider;
import gui.run.FloatListener;
import gui.run.LogFloatLabelJSlider;
import j3d.utils.Java3DExplorerConstants;
import j3d.utils.OffScreenCanvas3D;

import javax.media.j3d.*;
import javax.swing.*;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import java.applet.Applet;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class PolygonOffset extends Applet implements Java3DExplorerConstants {

    SimpleUniverse u;
    boolean isApplication;
    Canvas3D canvas;
    OffScreenCanvas3D offScreenCanvas;
    View view;

    PolygonAttributes solidPa;
    PolygonAttributes wirePa;
    float dynamicOffset = 1.0f;
    float staticOffset = 1.0f;
    ViewingPlatform viewingPlatform;
    float innerScale = 0.94f;
    TransformGroup innerTG;
    Transform3D scale;
    float sphereRadius = 0.9f;
    String outFileBase = "offset";
    int outFileSeq = 0;
    float offScreenScale = 1.0f;

    public BranchGroup createSceneGraph() {
        // Create the root of the branch graph
        BranchGroup objRoot = new BranchGroup();

        // Create the transform group node and initialize it to the
        // identity.  Enable the TRANSFORM_WRITE capability so that
        // our behavior code can modify it at runtime.  Add it to the
        // root of the subgraph.
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        objRoot.addChild(objTrans);

        // Create a Sphere.  We will display this as both wireframe and
        // solid to make a hidden line display
        // wireframe
        Appearance wireApp = new Appearance();

        ColoringAttributes wireCa = new ColoringAttributes();
        wireCa.setColor(black);
        wireApp.setColoringAttributes(wireCa);
        wirePa = new PolygonAttributes(PolygonAttributes.POLYGON_LINE,
                PolygonAttributes.CULL_BACK,
                0.0f);
        wireApp.setPolygonAttributes(wirePa);
        Sphere outWireSphere = new Sphere(sphereRadius, 0, 15, wireApp);
        objTrans.addChild(outWireSphere);

        // solid
        ColoringAttributes outCa = new ColoringAttributes(red,
                ColoringAttributes.SHADE_FLAT);
        Appearance outSolid = new Appearance();
        outSolid.setColoringAttributes(outCa);
        solidPa = new PolygonAttributes(PolygonAttributes.POLYGON_FILL,
                PolygonAttributes.CULL_BACK,
                0.0f);
        solidPa.setPolygonOffsetFactor(dynamicOffset);
        solidPa.setPolygonOffset(staticOffset);
        solidPa.setCapability(PolygonAttributes.ALLOW_OFFSET_WRITE);
        outSolid.setPolygonAttributes(solidPa);
        Sphere outSolidSphere = new Sphere(sphereRadius, 0, 15, outSolid);
        objTrans.addChild(outSolidSphere);

        innerTG = new TransformGroup();
        innerTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        scale = new Transform3D();
        updateInnerScale();
        objTrans.addChild(innerTG);


        // Create a smaller sphere to go inside.  This sphere has a different
        // tesselation and color
        Sphere inWireSphere = new Sphere(sphereRadius, 0, 10, wireApp);
        innerTG.addChild(inWireSphere);

        // inside solid
        ColoringAttributes inCa = new ColoringAttributes(blue,
                ColoringAttributes.SHADE_FLAT);
        Appearance inSolid = new Appearance();
        inSolid.setColoringAttributes(inCa);
        inSolid.setPolygonAttributes(solidPa);
        Sphere inSolidSphere = new Sphere(sphereRadius, 0, 10, inSolid);
        innerTG.addChild(inSolidSphere);


        // Create a new Behavior object that will perform the desired
        // operation on the specified transform object and add it into
        // the scene graph.
        Transform3D yAxis = new Transform3D();
        Alpha rotationAlpha = new Alpha(-1, Alpha.INCREASING_ENABLE,
                0, 0,
                80000, 0, 0,
                0, 0, 0);

        RotationInterpolator rotator =
                new RotationInterpolator(rotationAlpha, objTrans, yAxis,
                        0.0f, (float) Math.PI * 2.0f);
        BoundingSphere bounds =
                new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        rotator.setSchedulingBounds(bounds);
        objTrans.addChild(rotator);

        // set up a white background
        Background bgWhite = new Background(new Color3f(1.0f, 1.0f, 1.0f));
        bgWhite.setApplicationBounds(bounds);
        objTrans.addChild(bgWhite);

        // Have Java 3D perform optimizations on this scene graph.
        objRoot.compile();

        return objRoot;
    }

    void updateInnerScale() {
        scale.set(innerScale);
        innerTG.setTransform(scale);
    }

    public PolygonOffset() {
        this(false);
    }

    public PolygonOffset(boolean isApplication) {
        this.isApplication = isApplication;
    }


    public void init() {
        setLayout(new BorderLayout());

        GraphicsConfiguration config =
                SimpleUniverse.getPreferredConfiguration();

        JPanel canvasPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        canvasPanel.setLayout(gridbag);

        canvas = new Canvas3D(config);
        canvas.setSize(600, 600);
        add(canvas, BorderLayout.CENTER);

        u = new SimpleUniverse(canvas);

        if (isApplication) {
            offScreenCanvas = new OffScreenCanvas3D(config, true);
            // set the size of the off-screen canvas based on a scale
            // of the on-screen size
            Screen3D sOn = canvas.getScreen3D();
            Screen3D sOff = offScreenCanvas.getScreen3D();
            Dimension dim = sOn.getSize();
            dim.width *= offScreenScale;
            dim.height *= offScreenScale;
            sOff.setSize(dim);
            sOff.setPhysicalScreenWidth(sOn.getPhysicalScreenWidth() *
                    offScreenScale);
            sOff.setPhysicalScreenHeight(sOn.getPhysicalScreenHeight() *
                    offScreenScale);

// attach the offscreen canvas to the view
            u.getViewer().getView().addCanvas3D(offScreenCanvas);
        }

        // Create a simple scene and attach it to the virtual universe
        BranchGroup scene = createSceneGraph();

        // set the eye at z = 2.0
        viewingPlatform = u.getViewingPlatform();
        Transform3D vpTrans = new Transform3D();
        vpTrans.set(new Vector3f(0.0f, 0.0f, 2.0f));
        viewingPlatform.getViewPlatformTransform().setTransform(vpTrans);

        // set up a parallel projection with clip limits at 1 and -1
        view = u.getViewer().getView();
        view.setProjectionPolicy(View.PARALLEL_PROJECTION);
        view.setFrontClipPolicy(View.VIRTUAL_EYE);
        view.setBackClipPolicy(View.VIRTUAL_EYE);
        view.setFrontClipDistance(1.0f);
        view.setBackClipDistance(3.0f);

        u.addBranchGraph(scene);

        // set up the sliders
        JPanel guiPanel = new JPanel();
        guiPanel.setLayout(new GridLayout(0, 1));
        FloatLabelJSlider dynamicSlider = new FloatLabelJSlider("Dynamic Offset", 0.1f, 0.0f, 2.0f, dynamicOffset);
        dynamicSlider.addFloatListener(new FloatListener() {
            public void floatChanged(FloatEvent e) {
                dynamicOffset = e.getValue();
                solidPa.setPolygonOffsetFactor(dynamicOffset);
            }
        });
        guiPanel.add(dynamicSlider);

        LogFloatLabelJSlider staticSlider = new LogFloatLabelJSlider("Static Offset", 0.1f, 10000.0f, staticOffset);
        staticSlider.addFloatListener(new FloatListener() {
            public void floatChanged(FloatEvent e) {
                staticOffset = e.getValue();
                solidPa.setPolygonOffset(staticOffset);
            }
        });
        guiPanel.add(staticSlider);

        FloatLabelJSlider innerSphereSlider = new FloatLabelJSlider("Inner Sphere Scale", 0.001f, 0.90f, 1.0f, innerScale);
        innerSphereSlider.addFloatListener(new FloatListener() {
            public void floatChanged(FloatEvent e) {
                innerScale = e.getValue();
                updateInnerScale();
            }
        });
        guiPanel.add(innerSphereSlider);

        if (isApplication) {
            JButton snapButton = new JButton("Snap Image");
            snapButton.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    Point loc = canvas.getLocationOnScreen();
                    offScreenCanvas.setOffScreenLocation(loc);
                    Dimension dim = canvas.getSize();
                    dim.width *= offScreenScale;
                    dim.height *= offScreenScale;
                    nf.setMinimumIntegerDigits(3);
                    offScreenCanvas.snapImageFile(outFileBase + nf.format(outFileSeq++),
                            dim.width, dim.height);
                    nf.setMinimumIntegerDigits(0);
                }
            });
            guiPanel.add(snapButton);
        }
        add(guiPanel, BorderLayout.EAST);
    }

    public void destroy() {
        u.removeAllLocales();
    }

    //
    // The following allows PolygonOffset to be run as an application
    // as well as an applet
    //
    public static void main(String[] args) {
        new MainFrame(new PolygonOffset(true), 950, 600);
    }
}
