package j3d.examples.shape.cube;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;

import javax.media.j3d.*;
import java.applet.Applet;
import java.awt.*;

//   HelloJava3Dc renders a single, rotating cube.

public class Rotates extends Applet {

    public BranchGroup createSceneGraph() {
        // Create the root of the branch graph
        BranchGroup bg = new BranchGroup();

        // Create the transform group node and initialize it to the
        // identity. Add it to the root of the subgraph.
        TransformGroup tg = new TransformGroup();
        tg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        bg.addChild(tg);

        // Create a simple shape leaf node, add it to the scene graph.
        // ColorCube is a Convenience Utility class
        tg.addChild(new ColorCube(0.4));

        // Create a new Behavior object that will perform the desired
        // operation on the specified transform object and add it into
        // the scene graph.
        Alpha a = new Alpha(-1, 4000);
        RotationInterpolator ri =
                new RotationInterpolator(a, tg);
        BoundingSphere bs = new BoundingSphere();
        ri.setSchedulingBounds(bs);
        tg.addChild(ri);

        return bg;
    } // end of CreateSceneGraph method


    public Rotates() {
        setLayout(new BorderLayout());
        GraphicsConfiguration config =
                SimpleUniverse.getPreferredConfiguration();

        Canvas3D canvas3D = new Canvas3D(config);
        add("Center", canvas3D);

        BranchGroup scene = createSceneGraph();

        // SimpleUniverse is a Convenience Utility class
        SimpleUniverse simpleU = new SimpleUniverse(canvas3D);

        // This will move the ViewPlatform back a bit so the
        // objects in the scene can be viewed.
        simpleU.getViewingPlatform().setNominalViewingTransform();

        simpleU.addBranchGraph(scene);
    } // end of HelloJava3D (constructor)

    //  The following allows this to be run as an application
    //  as well as an applet

    public static void main(String[] args) {
        Frame frame = new MainFrame(new Rotates(), 256, 256);
    } // end of main (method of HelloJava3D)

} // end of class HelloJava3Dc
