/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.influences;
import javax.vecmath.Vector3f;
import j3d.examples.particles.emitters.Particle;

/**
 * An influence to slow a particle by deceleration.  The default
 * deceleration is 5 meters per second per second.
 */
public class Slow implements IExternalInfluence{
	private float rate;
	private Vector3f tempVector;

	public Slow() {
		this(5);
	}
	
	public Slow(float aRate) {
		rate = aRate;
		tempVector = new Vector3f();
	}
	public void initializeParticle(Particle aParticle){
		// Nothing to do
	}
	
	public void apply(Particle aParticle, float dt) {
		Vector3f a = (Vector3f)aParticle.getLocalVelocity().clone();
		a.negate();  // opposite direction of particle
		a.normalize();
		a.scale(rate);
		aParticle.addLocalAcceleration(a);
	}
}
