/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.influences;
import javax.vecmath.*;

import j3d.examples.particles.emitters.Particle;
/**
 * Assumes instant death upon collision between the
 * "ground" and the particle. 
 */
// TODO: Investigate the use of BoundingPolytope or BoundingBox
public class Kill implements IExternalInfluence {
	private float height;
	
	public Kill(){
		this(0);
	}
	
	public Kill(float aHeight){
		height = aHeight;
	}
	
	public void initializeParticle(Particle aParticle){
		// Nothing to do
	}
	
	public void apply(Particle aParticle, float dt) {
		Vector3f velocity = aParticle.getWorldVelocity();
		float[] position = aParticle.getWorldPosition();
		float newY = position[1] + velocity.y * dt;
		if(newY < height){
			aParticle.die();
		}
	}

}
