/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.influences;

import j3d.examples.particles.emitters.Particle;
import javax.media.j3d.*;

public class FadeShape extends Shape3DInfluence implements IExternalInfluence {
	private ParticleAgeAlpha alpha;
	/**
	 * Fade the opacity of a particle shape
	 * from fully opaque (transparency = 0) to fully
	 * transparent (transparency = 1) over the life of the
	 * affected particles.
	 */
	public FadeShape(){
		this(new ParticleAgeAlpha(0,0,0,1));
	}
	/**
	 * Fade the alpha component of the color of a shape
	 * based on the ParticleAgeAlpha object
	 * over the life of the affected particle.  The
	 * value returned by the ParticleAgeAlpha object
	 * represents the opacity of the particle.
	 * @param anAlpha - The particle age alpha to 
	 * control the opacity of the shape.
	 */
	public FadeShape(ParticleAgeAlpha anAlpha){
		alpha = anAlpha;
	}
	
	public void initializeParticle(Particle aParticle){
		if(isCompatible(aParticle)){
			Shape3D aShape = getShape3D(aParticle);
			allowChangeTransparency(aShape);
		}
	}
	
	public void apply(Particle aParticle, float dt) {
		if(isCompatible(aParticle)){
			Shape3D aShape = getShape3D(aParticle);
			Appearance a = aShape.getAppearance();
			TransparencyAttributes ta = a.getTransparencyAttributes();
			ta.setTransparency(1 - alpha.value(aParticle));
		}
	}

}
