/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.influences;

import j3d.examples.particles.emitters.Particle;
import j3d.examples.particles.*;

public class FadePoint implements IExternalInfluence {
	private ParticleAgeAlpha alpha;
	
	/**
	 * Fade the alpha component of the color of a point
	 * from fully opaque (alpha color = 1) to fully
	 * transparent (alpha color = 0) over the life of the
	 * affected particles.
	 */
	public FadePoint(){
		this(new ParticleAgeAlpha(0,0,0,1));
	}
	/**
	 * Fade the alpha component of the color of a point
	 * based on the ParticleAgeAlpha object
	 * over the life of the affected particle.  The
	 * value returned by the ParticleAgeAlpha object
	 * represents the alpha color of the particles.
	 * @param anAlpha - The particle age alpha to 
	 * control the opacity of the point.
	 */
	public FadePoint(ParticleAgeAlpha anAlpha){
		alpha = anAlpha;
	}
	
	public void initializeParticle(Particle aParticle){
		// Nothing to do 
	}
	
	public void apply(Particle aParticle, float dt) {
		IParticleSystem ps = aParticle.getEmitter().getParticleSystem();
		// Guard against accidental use with non-point particle systems
		if(ps instanceof ParticleSystem){
			ParticleSystem particleSystem = (ParticleSystem) ps;
			float[] color = particleSystem.getParticleColor(aParticle);
			color[3] = alpha.value(aParticle);
			particleSystem.setParticleColor(aParticle,color);
		}
	}

}
