/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.generationshapes;
import j3d.examples.particles.emitters.*;

import javax.vecmath.*;
/**
 * Emits particles along a line.  The line is along the x-axis and
 * particles are emitted in the direction of positive y-axis.
 * Particles are spread in the YZ plane based on the spread angle.
 */

public class LineGenerationShape
	extends GenerationShape
	implements IGenerationShape {
	float length;

	public LineGenerationShape(float spreadAngle, float aLength) {
		super(spreadAngle);
		length = aLength;
	}
	public LineGenerationShape(double spreadAngle, float aLength){
		this((float)spreadAngle, aLength);
	}
	public void initializeParticlePosition(Particle particle) {
		particle.setInitialLocalPosition(length * random(), 0, 0);
	}

	public void initializeParticleVelocity(Particle particle) {
		Vector3f velocity = new Vector3f();
		velocity.set(
			0,
			getVaryingParticleVelocity(),
			getVaryingParticleVelocity() * random() * getSpread());

		particle.setLocalVelocity(velocity);

	}

}
