/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.examples;

import javax.vecmath.*;
import javax.media.j3d.*;

public class XZPlane extends Shape3D {
	private float step;
	private int units;
	private boolean fill;
	private Color3f color;

	public XZPlane(float step, int units) {
		this(step, units, false, new Color3f(0.1f, 0.1f, 0.1f));
	}
	
	public XZPlane(float step, int units, boolean fill, Color3f aColor) {
		this.step = step;
		this.units = units;
		this.fill = fill;
		this.color = aColor;
		setGeometry(createGeometry());
		setAppearance(createAppearance());
	}

	protected int getVertexFormat() {
		int vertexFormat = GeometryArray.COORDINATES | GeometryArray.NORMALS;
		return vertexFormat;
	}

	protected Geometry createGeometry() {
		int numberOfVertices = units * units * 4;
		QuadArray geometry =
			new QuadArray(numberOfVertices, getVertexFormat());
		Point3f[] coordinates = new Point3f[numberOfVertices];
		Vector3f[] normals = new Vector3f[numberOfVertices];

		float z = step*(units/2);
		float x;

		int ci = 0; // coordinate index
		for (int row = 0; row < units; row++) {
			x = -step*(units/2);
			for (int col = 0; col < units; col++) {
				coordinates[ci + 0] = new Point3f(x, 0, z);
				coordinates[ci + 1] = new Point3f(x + step, 0, z);
				coordinates[ci + 2] = new Point3f(x + step, 0, z - step);
				coordinates[ci + 3] = new Point3f(x, 0, z - step);
				
				normals[ci + 0] = new Vector3f(0, 1f, 0);
				normals[ci + 1] = new Vector3f(0, 1f, 0);
				normals[ci + 2] = new Vector3f(0, 1f, 0);
				normals[ci + 3] = new Vector3f(0, 1f, 0);
				
				ci = ci + 4;
				x = x + step;
			}
			z = z - step;
		}
		
		geometry.setCoordinates(0, coordinates);
		geometry.setNormals(0, normals);
		return geometry;
	}

	protected Appearance createAppearance() {
		Appearance appearance = new Appearance();
		
		PolygonAttributes polyAttrib = new PolygonAttributes();
		polyAttrib.setCullFace(PolygonAttributes.CULL_NONE);
		if(fill){
			polyAttrib.setPolygonMode(PolygonAttributes.POLYGON_FILL);
		}
		else {
			polyAttrib.setPolygonMode(PolygonAttributes.POLYGON_LINE);
		}
		appearance.setPolygonAttributes(polyAttrib);
		
		ColoringAttributes ca = new ColoringAttributes();
		ca.setShadeModel(ColoringAttributes.NICEST);
		appearance.setColoringAttributes(ca);
		
		Material material = new Material();
		material.setAmbientColor(color);
		material.setSpecularColor(0.5f, 0.5f, 0.5f);
		//material.setDiffuseColor(0.3f, 0.3f, 0.3f);
		//material.setShininess(180);
		appearance.setMaterial(material);
				
		return appearance;
	}

}
