/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.examples;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.GraphicsConfiguration;

import javax.media.j3d.*;
import javax.vecmath.*;
import j3d.examples.particles.shapes.*;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;


public class ImplicitSurfaceExample extends Applet {

	public static void main(String[] args) {
		new MainFrame(new ImplicitSurfaceExample(), 512, 512);
	}
	
	public ImplicitSurfaceExample() {
		initialize();
	}
	
	public BranchGroup createSceneGraph(SimpleUniverse su) {
		BranchGroup objRoot = new BranchGroup();
		objRoot.addChild(new XZPlane(5, 10));	

		FuzzBall backBall = new FuzzBall(5, new Color3f(1,0,1));
		TransformGroup backGroup = new TransformGroup();
		Transform3D backTransform = new Transform3D();
		backTransform.setTranslation(new Vector3f(7.5f, 2.5f, -12.5f));
		backGroup.setTransform(backTransform);
		backGroup.addChild(backBall);
		objRoot.addChild(backGroup);
		
		FuzzBall backBall2 = new FuzzBall(5, new Color3f(0,1,1));
		TransformGroup backGroup2 = new TransformGroup();
		Transform3D backTransform2 = new Transform3D();
		backTransform2.setTranslation(new Vector3f(2.5f, 2.5f, -12.5f));
		backGroup2.setTransform(backTransform2);
		backGroup2.addChild(backBall2);
		objRoot.addChild(backGroup2);
		
		FuzzBall frontBall = new FuzzBall(5, new Color3f(1,1,0));
		TransformGroup frontGroup = new TransformGroup();
		Transform3D frontTransform = new Transform3D();
		frontTransform.setTranslation(new Vector3f(5, 2.5f, -7.5f));
		frontGroup.setTransform(frontTransform);
		frontGroup.addChild(frontBall);
		objRoot.addChild(frontGroup);
		
		FakeSphere fakeSphere = new FakeSphere(2.5f, new Color3f(0.4f,0.0f,0.4f));
		TransformGroup fakeSphereGroup = new TransformGroup();
		Transform3D fakeSphereTransform = new Transform3D();
		fakeSphereTransform.setTranslation(new Vector3f(12f, 2.5f, 0f));
		fakeSphereGroup.setTransform(fakeSphereTransform);
		fakeSphereGroup.addChild(fakeSphere);
		objRoot.addChild(fakeSphereGroup);
		
		FakeSphere fakeSphere2 = new FakeSphere(2.5f, new Color3f(0,0.4f,0.4f));
		TransformGroup fakeSphereGroup2 = new TransformGroup();
		Transform3D fakeSphereTransform2 = new Transform3D();
		fakeSphereTransform2.setTranslation(new Vector3f(5f, 2.5f, 0f));
		fakeSphereGroup2.setTransform(fakeSphereTransform2);
		fakeSphereGroup2.addChild(fakeSphere2);
		objRoot.addChild(fakeSphereGroup2);
		
		FakeSphere fakeSphere3 = new FakeSphere(2.5f, new Color3f(0.4f,0.4f,0));
		TransformGroup fakeSphereGroup3 = new TransformGroup();
		Transform3D fakeSphereTransform3 = new Transform3D();
		fakeSphereTransform3.setTranslation(new Vector3f(8.5f, 2.5f, 5f));
		fakeSphereGroup3.setTransform(fakeSphereTransform3);
		fakeSphereGroup3.addChild(fakeSphere3);
		objRoot.addChild(fakeSphereGroup3);
		
		CloudPuff cloud = new CloudPuff(8, new Color3f(0.5f,0.5f,0.5f));
		TransformGroup cloudGroup = new TransformGroup();
		Transform3D cloudTransform = new Transform3D();
		cloudTransform.setTranslation(new Vector3f(-10, -2.5f, 2.25f));
		cloudGroup.setTransform(cloudTransform);
		cloudGroup.addChild(cloud);
		objRoot.addChild(cloudGroup);
		
		CloudPuff cloud2 = new CloudPuff(6, new Color3f(0.7f,0.7f,0.7f));
		TransformGroup cloudGroup2 = new TransformGroup();
		Transform3D cloudTransform2 = new Transform3D();
		cloudTransform2.setTranslation(new Vector3f(-12.5f, 2.5f, 0f));
		cloudGroup2.setTransform(cloudTransform2);
		cloudGroup2.addChild(cloud2);
		objRoot.addChild(cloudGroup2);
		
		CloudPuff cloud3 = new CloudPuff(12, new Color3f(0.8f,0.8f,0.8f));
		TransformGroup cloudGroup3 = new TransformGroup();
		Transform3D cloudTransform3 = new Transform3D();
		cloudTransform3.setTranslation(new Vector3f(-8.5f, 1.25f, -1.25f));
		cloudGroup3.setTransform(cloudTransform3);
		cloudGroup3.addChild(cloud3);
		objRoot.addChild(cloudGroup3);
		
		BoundingSphere bounds = new BoundingSphere();
		bounds.setRadius(1000);
		AmbientLight ambient = new AmbientLight();
		ambient.setColor(new Color3f(1f, 1f, 1f));
		ambient.setInfluencingBounds(bounds);
		objRoot.addChild(ambient);

		// Add a directional light
		DirectionalLight directional = new DirectionalLight();
		directional.setDirection(1.0f, -0.4f, 1f);
		directional.setColor(new Color3f(0.7f, 0.7f, 0.7f));
		directional.setInfluencingBounds(bounds);
		objRoot.addChild(directional);	
	
		// Add a keyboard navigator to move around
		TransformGroup vpTrans =
			su.getViewingPlatform().getViewPlatformTransform();
		KeyNavigatorBehavior keyNavBeh =
			new KeyNavigatorBehavior(vpTrans);
		keyNavBeh.setSchedulingBounds(bounds);
		objRoot.addChild(keyNavBeh);

		// Optimize the scene graph
		objRoot.compile();
		return objRoot;
	}
	private void initialize() {
		setLayout(new BorderLayout());
		GraphicsConfiguration config =
			SimpleUniverse.getPreferredConfiguration();
		Canvas3D canvas3D = new Canvas3D(config);
		add("Center", canvas3D);
		SimpleUniverse simpleU = new SimpleUniverse(canvas3D);
		
		//Position the view
		TransformGroup viewingPlatformGroup =
			simpleU.getViewingPlatform().getViewPlatformTransform();
		Transform3D t3d = new Transform3D();
		t3d.setTranslation(new Vector3f(0, 0, 10));
		viewingPlatformGroup.setTransform(t3d);

		BranchGroup scene = createSceneGraph(simpleU);
		simpleU.addBranchGraph(scene);

		// Adjust the clipping planes
		canvas3D.getView().setBackClipDistance(300.0d);
		canvas3D.getView().setFrontClipDistance(0.1d);
		
		//canvas3D.getView().setTransparencySortingPolicy(View.TRANSPARENCY_SORT_NONE);
		canvas3D.getView().setTransparencySortingPolicy(View.TRANSPARENCY_SORT_GEOMETRY);
	}

}
