/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.examples;
import javax.media.j3d.*;
import java.util.Enumeration;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.*;
import javax.imageio.*;
import javax.vecmath.*;

import javax.media.j3d.Behavior;

public class ImageCaptureBehavior extends Behavior {
	private Canvas3D canvas;
	private String fileType;
	private int frameCount = 0;
	ImageComponent2D image;
	private String location;
	private int maximumFrames;
	Raster raster;
	private WakeupOnElapsedFrames wakeupCondition = null;

	public ImageCaptureBehavior(Canvas3D aCanvas, int interval) {
		this(aCanvas, interval, 1000);
	}

	public ImageCaptureBehavior(
		Canvas3D aCanvas,
		int interval,
		int maximumFrames) {
		this(aCanvas, interval, maximumFrames, "c:\\captured\\", "png");
	}
	
	public ImageCaptureBehavior(
		Canvas3D aCanvas,
		int interval,
		int maximumFrames,
		String location,
		String fileType) {
		canvas = aCanvas;
		this.maximumFrames = maximumFrames;
		this.location = location;
		this.fileType = fileType;
		wakeupCondition = new WakeupOnElapsedFrames(interval);
	}
	
	private void captureImage(String aName) {
		GraphicsContext3D context = canvas.getGraphicsContext3D();
		context.readRaster(getRaster());
		BufferedImage bi = (getRaster().getImage()).getImage();
		Graphics2D g = bi.createGraphics();
		Font font = new Font("Arial", Font.PLAIN, 10);
		g.setFont(font);
		g.drawString("Copyright (C) 2005, Michael Jacobs", 10,10);
		try {
			File outfile = new File(location + aName + "." + fileType);
			//String[] formatNames = ImageIO.getWriterFormatNames();
			ImageIO.write(bi, fileType, outfile);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	protected ImageComponent2D getImage(int height, int width) {
		if (image == null) {
			BufferedImage bi =
				new BufferedImage(height, width, BufferedImage.TYPE_INT_ARGB);

			image =
				new ImageComponent2D(
					ImageComponent2D.FORMAT_RGBA,
					bi,
					true,
					false);
		}

		return image;
	}
	
	protected Raster getRaster() {
		if (raster == null) {
			int height = canvas.getBounds().height;
			int width = canvas.getBounds().width;
			raster =
				new Raster(
					new Point3f(-1.0f, -1.0f, -1.0f),
					Raster.RASTER_COLOR,
					0,
					0,
					height,
					width,
					getImage(height, width),
					null);
		}
		return raster;

	}

	public void initialize() {
		System.out.println("I M A G E   C A P T U R E   M O D E");
		wakeupOn(wakeupCondition);
	}

	public void processStimulus(Enumeration criteria) {

		WakeupCriterion criterion;
		while (criteria.hasMoreElements()) {
			criterion = (WakeupCriterion) criteria.nextElement();
			if (criterion instanceof WakeupOnElapsedFrames) {
				captureImage("IMG_" + frameCount);
				frameCount++;
				if (frameCount % 100 == 0) {
					System.out.println(frameCount);
				}
			}
		}
		if (frameCount <= maximumFrames) {
			wakeupOn(wakeupCondition);
		} else {
			System.out.println("Maximum number of frames reached");
		}

	}

}
