/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.examples;
import javax.media.j3d.*;
import java.util.Enumeration;

import javax.media.j3d.Behavior;

/*
 * Based on the FpsBehavior in Daniel Selman's 'Java3D Programming'
 */
public class FrameRateBehavior extends Behavior {
	private WakeupOnElapsedFrames wakeupCondition = null;
	private static int REPORT_INTERVAL = 100; // Number of frames between reports
	private long startTime = 0;

	public FrameRateBehavior(int interval) {
		wakeupCondition = new WakeupOnElapsedFrames(interval);
	}

	public FrameRateBehavior() {
		wakeupCondition = new WakeupOnElapsedFrames(REPORT_INTERVAL);
	}

	public void initialize() {
		wakeupOn(wakeupCondition);
	}

	public void processStimulus(Enumeration criteria) {

		WakeupCriterion criterion;
		while (criteria.hasMoreElements()) {
			criterion = (WakeupCriterion) criteria.nextElement();
			if (criterion instanceof WakeupOnElapsedFrames) {
				if (startTime > 0) {
					final long duration = System.currentTimeMillis() - startTime;
					System.out.println("FPS: " + (wakeupCondition.getElapsedFrameCount() * 1000) / duration);
				}

				startTime = System.currentTimeMillis();
			}
		}
		wakeupOn(wakeupCondition);

	}

}
