/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles;

import javax.vecmath.*;
import javax.media.j3d.*;

import j3d.examples.particles.emitters.*;

public class MotionBlurredParticleSystem extends ParticleSystem {
	private Color4f fadeColor;
	
	public MotionBlurredParticleSystem(ParticleEmitter emitter) {
		this(emitter, new Color3f(0, 1, 1));
	}
	
	public MotionBlurredParticleSystem(ParticleEmitter emitter, Color3f particleColor){
		this(emitter, particleColor, new Color3f(1, 1, 1));
	}
	
	public MotionBlurredParticleSystem(ParticleEmitter emitter, Color3f particleColor, Color3f fadeColor){
		super(emitter, particleColor);
		this.fadeColor = new Color4f(fadeColor.x, fadeColor.y, fadeColor.z, 0);
		postConstructionInitialization();
	}
	
	protected Color4f getFadeColor(){
		return fadeColor;
	}
	
	protected int getVerticesPerParticle(){
		return 2;
	}
	
	protected Geometry createGeometry() {
		LineArray geometry = new LineArray(2*getMaximumParticles(), getVertexFormat());
		float[] coordinates = getEmitter().getPositions();
		geometry.setCoordRefFloat(coordinates);
		
		Color4f color = getParticleColor();
		Color4f fadeColor = getFadeColor();
		for (int i = 0; i < getMaximumParticles(); i++) {
			int ci = 4 * 2 * i;
			setParticleColor(ci, color.x, color.y, color.z, color.w);
			setParticleColor(ci + 4, fadeColor.x, fadeColor.y, fadeColor.z, fadeColor.w);
		}
		geometry.setColorRefFloat(getColors());
					
		return geometry;
	}

	protected int getVertexFormat() {
		int vertexFormat =
			GeometryArray.COORDINATES
				| GeometryArray.COLOR_4
				| GeometryArray.BY_REFERENCE;
		return vertexFormat;
	}

	protected Appearance createAppearance() {
		Appearance appearance = new Appearance();
		LineAttributes la = new LineAttributes(2, LineAttributes.PATTERN_SOLID, true);
		appearance.setLineAttributes(la);
		
		TransparencyAttributes ta = new TransparencyAttributes();
		ta.setTransparencyMode(TransparencyAttributes.NICEST);
		appearance.setTransparencyAttributes(ta);
		return appearance;
	}

}
