package j3d.examples.appearance.texture.noise;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;

import javax.media.j3d.*;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;
import java.applet.Applet;
import java.awt.*;

public class StarGateMain extends Applet implements IElapsedTimeListener {
    private static final float SIDE_LENGTH = 350.0f; // Meters
    private static final int DIVISIONS = 100;
    private static final float WAVE_SIZE = 2f;

    private Water water;
    private int ticks = 0;

    public StarGateMain() {
        initialize();
    }

    private void initialize() {
        setLayout(new BorderLayout());
        GraphicsConfiguration config =
                SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas3D = new Canvas3D(config);
        add("Center", canvas3D);
        SimpleUniverse simpleU = new SimpleUniverse(canvas3D);

        positionTheView(simpleU);

        simpleU.addBranchGraph(getTheSceneGraphBranchGroup(simpleU));

        adjustTheClippingPlanes(canvas3D);
    }

    private void positionTheView(SimpleUniverse simpleU) {
        TransformGroup viewingPlatformGroup =
                simpleU.getViewingPlatform().getViewPlatformTransform();
        Transform3D t3d = new Transform3D();
        t3d.rotX(-Math.PI / 2);
        t3d.setTranslation(new Vector3f(SIDE_LENGTH / 2, SIDE_LENGTH, -SIDE_LENGTH / 2));
        viewingPlatformGroup.setTransform(t3d);
    }

    private void adjustTheClippingPlanes(Canvas3D canvas3D) {
        canvas3D.getView().setBackClipDistance(3000.0d);
        canvas3D.getView().setFrontClipDistance(1d);
    }

    public void tick() {
        // Called when the timer wakes us up.
        water.nextFrame(++ticks);
    }

    public BranchGroup getTheSceneGraphBranchGroup(SimpleUniverse su) {
        BranchGroup bg = new BranchGroup();

        water = new Water(SIDE_LENGTH, DIVISIONS, WAVE_SIZE);
        bg.addChild(water);

        // Add ambient light
        BoundingSphere bounds = new BoundingSphere();
        bounds.setRadius(10000);
        AmbientLight ambient = new AmbientLight();
        ambient.setColor(new Color3f(1f, 1f, 1f));
        ambient.setInfluencingBounds(bounds);
        bg.addChild(ambient);

        // Add a spot light in under the surface,
        // in the middle and pointing up.
        SpotLight spot = new SpotLight();
        spot.setDirection(0f, -1f, 0f);
        spot.setPosition(SIDE_LENGTH / 2, 4 * SIDE_LENGTH, -SIDE_LENGTH / 2);
        spot.setSpreadAngle((float) Math.PI / 4);
        spot.setConcentration(70f);
        spot.setInfluencingBounds(bounds);
        bg.addChild(spot);

        // Add a directional light
        DirectionalLight directional = new DirectionalLight();
        directional.setDirection(0f, -1f, 0f);
        directional.setColor(new Color3f(0.4f, 0.4f, 0.4f));
        directional.setInfluencingBounds(bounds);
        bg.addChild(directional);

        // Add a behavior to notify us when a certain
        // amount of time has passed.  This is used
        // to animate the water.
        ElapsedTimeBehavior timer = new ElapsedTimeBehavior(this, 50);
        timer.setSchedulingBounds(bounds);
        bg.addChild(timer);

        // Add a keyboard navigator to move around
        TransformGroup vpTrans =
                su.getViewingPlatform().getViewPlatformTransform();
        KeyNavigatorBehavior keyNavBeh =
                new KeyNavigatorBehavior(vpTrans);
        keyNavBeh.setSchedulingBounds(bounds);
        bg.addChild(keyNavBeh);

        // Optimize the scene graph
        bg.compile();
        return bg;
    }

    public static void main(String[] args) {
        // Depending on the options used,
        // you may need to use the -Xms256M -Xmx1000M
        // options when running this example.

        new MainFrame(new StarGateMain(), 300, 300);
    }

}
