/*
    Earth.java
    Program to display rotating earth
    By Roger T. Stevens  4-5-99
*/
package j3d.examples.appearance.texture;

import com.sun.j3d.utils.applet.MainFrame;
import j3d.utils.BasicUniverse;
import j3d.utils.Utils;
import utils.ResourceManager;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import java.applet.Applet;
import java.awt.*;
import java.io.File;

public class SpinningEarth extends Applet {

    public SpinningEarth() {
        Canvas3D c = Utils.getCanvas3D(this);
        add(c, BorderLayout.CENTER);

        File fn = new File("earth.jpg");
        BranchGroup bg = Utils.getTextureSphere(0.5,
                0, 0, ResourceManager.getResourceManager().getImageFile(fn));
        BasicUniverse u = new BasicUniverse(c, 10);
        u.addBranchGraph(bg);
    }

    public static void main(String[] args) {
        new MainFrame(new SpinningEarth(), 200, 200);
    }
}
