package j2d.rotator;

import gui.ClosableJFrame;
import gui.run.RunAffinePanel;
import j2d.ImageUtils;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.AffineTransform;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Dec 10, 2004
 * <p/>
 * Time: 7:20:50 PM
 */
public class AffineMediator {
    protected Image image;

    protected AffineTransform lastTransform = new AffineTransform();
    protected AffineTransform priorTransform = new AffineTransform();
    protected final ImagePanel imagePanel = new ImagePanel();

    protected void getNewImage() {
        image = ImageUtils.getImage();
    }


    public class ImagePanel extends JPanel {
        AffineTransform at = new AffineTransform();

        ImagePanel() {
            initAffineGUI();
        }

        public void initAffineGUI() {
            ClosableJFrame cf = new ClosableJFrame();
            Container c = cf.getContentPane();
            c.setLayout(new FlowLayout());
            RunAffinePanel rap = new RunAffinePanel() {
                public void run() {
                    at = getValue();
                    ImagePanel.this.repaint();
                }
            };
            c.add(rap);
            mediator(rap);
            cf.setSize(400, 400);
            cf.setVisible(true);
        }

        private void mediator(RunAffinePanel rap) {
            ImagePanel.this.addMouseListener(rap);
            ImagePanel.this.addMouseMotionListener(rap);
        }

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D) g;
            Dimension d = getSize();
            g2.setColor(Color.blue);
            g2.fillRect(0, 0, d.width, d.height);
            g2.setTransform(at);
            lastTransform = at;
            if (image == null) return;
            g2.drawImage(image, 0, 0, this);
        }
    }
}
