/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.io.gif.stills;

public class ScreenDescriptor {
    public short localScreenWidth_, localScreenHeight_;
    private byte byte_;
    public byte backgroundColorIndex_, pixelAspectRatio_;

    public ScreenDescriptor(
            short width, short height, int numColors) {
        localScreenWidth_ = width;
        localScreenHeight_ = height;
        SetGlobalColorTableSize(
                (byte) (BitUtils.bitsNeeded(numColors) - 1));
        SetGlobalColorTableFlag((byte) 1);
        SetSortFlag((byte) 0);
        SetColorResolution((byte) 7);
        backgroundColorIndex_ = 0;
        pixelAspectRatio_ = 0;
    }

    public void write(java.io.OutputStream os)
            throws java.io.IOException {
        BitUtils.writeWord(os, localScreenWidth_);
        BitUtils.writeWord(os, localScreenHeight_);
        os.write(byte_);
        os.write(backgroundColorIndex_);
        os.write(pixelAspectRatio_);
    }

    public void SetGlobalColorTableSize(byte num) {
        byte_ |= (num & 7);
    }

    public void SetSortFlag(byte num) {
        byte_ |= (num & 1) << 3;
    }

    public void SetColorResolution(byte num) {
        byte_ |= (num & 7) << 4;
    }

    public void SetGlobalColorTableFlag(byte num) {
        byte_ |= (num & 1) << 7;
    }
}
