/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Feb 28, 2003
 * Time: 7:44:33 AM
 */
package j2d.hpp;

import j2d.ImageProcessorInterface;

import java.awt.*;


public class Threshold3Processor implements
        HppFilter3Interface,
        ImageProcessorInterface {
    private double threshold;

    public Threshold3Processor(double _b) {
        threshold = _b;
    }

    public Image process(Image img) {
        System.out.println("threshold="+threshold);
        return new HppFilter3ImageProcessor(
                new Threshold3Processor(threshold)
                        ).process(img);
    }
    public int average(int r, int g, int b){
        return (r + g + b)/3;
    }
    public short getR(int r, int g, int b) {
        return thresholdFunction(average(r,g,b));
    }

    public short getG(int r, int g, int b) {
        return thresholdFunction(average(r,g,b));
    }

    public short getB(int r, int g, int b) {
        return thresholdFunction(average(r,g,b));
    }

    private short thresholdFunction(double v) {
        if (v < threshold) return 0;
        return 255;
    }

}
