/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Feb 28, 2003
 * Time: 7:42:23 AM
 */
package j2d.hpp;


public class GreyHppFilter3 implements HppFilter3Interface {
    private float ar = 1;
    private float ag = 1;
    private float ab = 1;

    public GreyHppFilter3(float ar, float ag, float ab) {
        this.ar = ar;
        this.ag = ag;
        this.ab = ab;
    }

    public short getR(int r, int g, int b) {
        return avg(r, g, b);
    }

    public short getG(int r, int g, int b) {
        return avg(r, g, b);
    }

    public short getB(int r, int g, int b) {
        return avg(r, g, b);
    }

    private final short avg(int r, int g, int b) {
        return (short) ((r * ar + g * ag + b * ab) / 3);
    }
}
