/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Feb 28, 2003
 * Time: 7:44:33 AM
 */
package j2d.hpp;

import math.RgbStats;

import java.awt.*;


public class EnaheFilter
        implements HppFilterInterface {
    /*
         short lut[] = tt.getLut();
        RgbStats rgbStats = new RgbStats(ib.getImage());
        double averageCmf[] = rgbStats.getAverageCmf();
        for (short i = 0; i < lut.length; i++)
            lut[i] = (short) (255 * averageCmf[i]);
        applyLut(lut);
    */
    double averageCmf[] = null;
    double alpha;

    public EnaheFilter(Image img, double alpha) {
        this.alpha = alpha;
        RgbStats rgbStats = new RgbStats(img);
        this.averageCmf = rgbStats.getAverageCmf();
    }

    public short getR(int r) {
        return
                getEnauhe(r);
    }

    private short getEnauhe(int r) {
        short v = (short)
                (255 * (-Math.log(1.0 - averageCmf[r]) / alpha));
        if (v < 0) return v;
        if (v > 255) return 255;
        return v;
    }

    public short getG(int g) {
        return getR(g);
    }

    public short getB(int b) {
        return getR(b);
    }

}
