package j2d.filters;

import gui.layouts.DialogLayout;
import gui.run.RunButton;
import gui.run.RunSpinnerSlider;
import j2d.ImageProcessListener;

import javax.swing.*;
import java.awt.*;


public class GaussianPanel extends JPanel {


    private int widGaussianKernel = 15;
    private double sigma = 2.0;

    ImageProcessListener ipl = null;

    /**
     * Construct the frame
     */
    public GaussianPanel(ImageProcessListener _ipl) {
        ipl = _ipl;
        initGuiElements();

    }

    /**
     * Component initialization
     */
    private void initGuiElements() {
        setLayout(new DialogLayout());
        add(new JLabel("kernel width"));

        add(new RunSpinnerSlider(new SpinnerNumberModel(15, 3, 40, 1)) {
            public void run() {
                widGaussianKernel = getValue();
                updateImage();
            }
        });
        add(new JLabel("sigma"));
        add(new RunSpinnerSlider(new SpinnerNumberModel(2, 1, 10, 1)) {
            public void run() {
                sigma = getValue();
                updateImage();
            }
        });
        add(new JLabel("Button Control Panel"));
        add(getButtonControlPanel());
    }

    private JPanel getButtonControlPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(new RunButton("apply") {
            public void run() {
                updateImage();
            }
        });
        jp.add(new RunButton("Reset") {
            public void run() {
                ipl.update(null);
            }
        });
        return jp;
    }

    public void updateImage() {
        ipl.update(new GaussianSmoothingProcessor(widGaussianKernel,
                sigma));
    }


}
