package j2d.edge;

import ip.transforms.Kernels;
import j2d.ImageProcessorInterface;
import j2d.ImageUtils;

import java.awt.*;


public class MagDOGProcessor implements ImageProcessorInterface {

    private int kernelWidth;
    private double sigma;


    public MagDOGProcessor(
            int _kernelWidth,
            double _sigma) {

        kernelWidth = _kernelWidth;
        sigma = _sigma;
    }

    public Image process(Image img) {
        return ImageUtils.sobel(
                magDoG(img));

    }


    private Image magDoG(Image img) {
        return ImageUtils.convolution(img,
                Kernels.getMagnitudeOfTheDerivativeOfGauss(
                        kernelWidth, kernelWidth, sigma));
    }

}

