/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.color.rgbImageFilters;

import gui.run.RunButton;
import gui.run.RunSlider;
import j2d.gui.Main;
import j2d.LogXform;

import javax.swing.*;
import java.awt.*;

public class LogXformPanel
        extends JPanel {

    int numberOfRings = 5;
    int numberOfSectors = 5;

    public LogXformPanel(final Main main) {

        setLayout(new FlowLayout());

        add(new RunSlider(1,500) {
            public void run() {
                numberOfRings = getValue();
                main.process(new LogXform(numberOfRings, numberOfSectors));
            }
        });
         add(new RunSlider(1,500) {
            public void run() {
                numberOfSectors = getValue();
                main.process(new LogXform(numberOfRings, numberOfSectors));
            }
        });

        add(new RunButton("re[vert") {
            public void run() {
                main.revertImage();
            }
        });
        add(new RunButton("[apply") {
            public void run() {
                main.apply();
            }
        });


    }



}
