/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.color.rgbImageFilters;




/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 27, 2005
 * <p/>
 * Time: 8:10:56 AM
 */
public class LinearCutFilter extends RgbFilterProcessor {
    private int lut[] ;
    int mask;
    public LinearCutFilter(int numberOfBitsToCut) {
        // When this is set to true, the filter will work with images
        // whose pixels are indices into a color table (IndexColorModel).
        // In such a case, the color values in the color table are filtered.
        canFilterIndexColorModel = true;
        mask = 255 << numberOfBitsToCut;
        lut = getLut();
    }

    public int filterRGB(int x, int y, int rgb) {
        return (0xff000000|
                lut[((rgb & 0x00ff0000)>>16)] << 16 |
                lut[((rgb & 0x0000ff00) >> 8)] << 8 |
                lut[(rgb & 0x000000ff)]);
    }
    private int[] getLut(){
        int lut[]= new int[256];
        for (int i=0; i < lut.length;i++)
            lut[i] = f(i);
        return lut;
    }


    public int f(int x){
        return x & mask;
    }

    public static void main(String[] args) {
        LinearCutFilter lcf = new LinearCutFilter(3);
        int lut[] = lcf.getLut();
        for (int i=0; i <lut.length;i++)
            System.out.println(i+","+lut[i]+","+lcf.f(i));
    }
}
