/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.color.rgbImageFilters;

import j2d.ImageProcessorInterface;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 27, 2005
 * <p/>
 * Time: 8:10:56 AM
 */
public class BlueFilter extends RgbFilterProcessor
        implements ImageProcessorInterface {
    public BlueFilter() {
        // When this is set to true, the filter will work with images
        // whose pixels are indices into a color table (IndexColorModel).
        // In such a case, the color values in the color table are filtered.
        canFilterIndexColorModel = true;
    }

    // This method is called for every pixel in the image
    public int filterRGB(int x, int y, int rgb) {
        if (x == -1) {
            // The pixel value is from the image's color table rather than the image itself
        }
        // Return only the blue component
        return rgb & 0xff0000ff;
    }

}
