/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.animation;

import gui.In;
import j2d.ImageUtils;
import j2d.color.rgbImageFilters.ColorSafeFilter;
import j2d.io.gif.gifAnimation.Gif89Encoder;
import video.jsnap.NeuquantCaptureBean;

import java.awt.*;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: May 22, 2005
 * <p/>
 * Time: 6:48:43 AM
 */
public class ColorSafeAnimationEncoder {
    FileOutputStream fos = null;
    Gif89Encoder ge = new Gif89Encoder();
    ColorSafeFilter csf = new ColorSafeFilter();
    int speed;
    private NeuquantCaptureBean ncb;

    public ColorSafeAnimationEncoder(NeuquantCaptureBean ncb)
            throws FileNotFoundException {
        this.ncb = ncb;
        this.fos = new FileOutputStream(ncb.getOutputFile());
        speed = (int) (ncb.getSecondsPerFrame() * 100);


    }

    public void writeImage(Image inputImage) {
        try {
            final Image outputImage = csf.process(inputImage);
            if (ncb.isSnrComputed()) {
                System.out.println(
                        "SNR dB:"+
                        ImageUtils.getSNRinDb(inputImage,outputImage));
            }
            ge.addFrame(outputImage);
            ge.setUniformDelay(speed);
        } catch (IOException e) {
            In.message(e);
        }

    }

    public void close() {
        if (ncb.isLooped())
            ge.setLoopCount(0);
        else
            ge.setLoopCount(1);

        try {
            ge.encode(fos);
            fos.close();
        } catch (IOException e) {
            In.message(e);

        }
    }
}
