package ip.raul;

import java.awt.*;
import java.awt.event.*;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class MyFileDialog extends Dialog implements
        ActionListener, ItemListener, WindowListener {

    public String currentPath = new String();
    public InputStream theFile = null;
    public String hostName = "vinny.bridgeport.edu";
    public String userName = "anonymous";
    public String password = "ip.raul@bridgeport.edu";


    private static int colSpace = 5;
    private static int rowSpace = 5;

    private Choice Dirs = new Choice();
    private List fileList = new List(11, false);
    public Choice Ftypes = new Choice();
    public Button openButton = new Button("Open");
    public Button cancelButton = new Button("Cancel");
    private TextField fName = new TextField("");

    public MyFileDialog(Frame parent) {
        super(parent, "Select File, please...", false);

        init();
    }

    public static void main(String args[]) {
        MyFileDialog mf = new MyFileDialog(new Frame("d"));
        mf.setVisible(true);
    }

    public void init() {
        Panel p0 = new Panel();
        Panel p1 = new Panel();
        Panel p2 = new Panel();
        p0.setLayout(new GridLayout(1, 2, rowSpace, colSpace));
        p1.setLayout(new GridLayout(1, 2, rowSpace, colSpace));
        p2.setLayout(new GridLayout(2, 3, rowSpace, colSpace));
        p0.add(new Label("Look in folder:"));
        p0.add(Dirs);
        p1.add(fileList);
        p2.add(new Label("File name:"));
        p2.add(fName);
        p2.add(openButton);
        p2.add(new Label("Files of type:"));
        p2.add(Ftypes);
        p2.add(cancelButton);
        add("North", p0);
        add("Center", p1);
        add("South", p2);

        Ftypes.removeAll();
        Dirs.removeAll();
        currentPath = "/";
        Dirs.add(currentPath);
        Ftypes.addItem("All");
        Ftypes.addItem(".ip.gif");
        Ftypes.addItem(".jpg");
        Ftypes.addItem(".ppm");
        Ftypes.addItem(".java");
        Ftypes.addItem(".gui.html");
        Ftypes.addItem(".zip");
        Ftypes.select(Ftypes.getItem(0));

        pack();
        setSize(400, 300);
        setVisible(true);
        cancelButton.addActionListener(this);
        openButton.addActionListener(this);
        addWindowListener(this);
        Dirs.addItemListener(this);
        fileList.addItemListener(this);
        Ftypes.addItemListener(this);

    }


    public void UpdateDIRS() {
        String txt1 = new String();
        Dirs.removeAll();
        Dirs.add("/");
        StringTokenizer parser = new StringTokenizer(currentPath, "/");
        try {
            while (parser.hasMoreElements()) {
                txt1 = (String) parser.nextElement();
                Dirs.addItem(txt1 + "/");
            }
        } catch (NoSuchElementException e) {
        }
        Dirs.select(Dirs.getItem(Dirs.getItemCount() - 1));
    }


    private void Dirs_Click() {
        try {
            String txt = new String();
            int i1 = Dirs.getSelectedIndex();
            txt = "";
            for (int i = 0; i <= i1; i++) {
                txt = txt + Dirs.getItem(i);
            }
            currentPath = txt;
            UpdateDIRS();
        } catch (Exception ex) {
        }
    }


    private void fileList_Click() {
        String txt = new String();
        try {
            txt = fileList.getItem(fileList.getSelectedIndex());
            if (txt.endsWith("/")) {
                Dirs.addItem(txt);
                Dirs.select(Dirs.getItem(Dirs.getItemCount() - 1));
                currentPath = currentPath + txt;

            } else {
                fName.setText(txt);
            }
        } catch (Exception ex) {
        }
    }


    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == Dirs) {
            Dirs_Click();
            return;
        }
        if (e.getSource() == fileList) {
            fileList_Click();
            return;
        }

    }


    public void actionPerformed(ActionEvent e) {
        Button b = (Button) e.getSource();
        if (b == cancelButton) setVisible(false);

    }

    public void windowClosing(WindowEvent e) {
        dispose();
    }

    public void windowClosed(WindowEvent e) {
    };
    public void windowDeiconified(WindowEvent e) {
    };
    public void windowIconified(WindowEvent e) {
    };
    public void windowActivated(WindowEvent e) {
    };
    public void windowDeactivated(WindowEvent e) {
    };
    public void windowOpened(WindowEvent e) {
    };


}