package ip.hak;

import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class SmallImage extends ImageComponent implements MouseListener {

    FileDialog fd;
    Image im;
    boolean iLoad = false;
    int index;

    public SmallImage(int w, int h, MyPanel myp, int idx) {
        mp = myp;
        index = idx;
        setSize(w, h);
        addMouseListener(this);
    }

    public Image getResizedImage(int wid, int hei) {
        if (im == null)
            return null;
        Image ni = im.getScaledInstance(wid, hei, Image.SCALE_DEFAULT);
        return ni;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (im == null) {
            Dimension d = getSize();
            g.drawString("Click", d.width / 2 - 15, d.height / 2 + 5);
            return;
        }
        Dimension d = getSize();
        g.drawImage(im, 0, 0, d.width, d.height, this);
        iLoad = true;
        mp.setImageSize(im.getWidth(this), im.getHeight(this), index);
    }

    public void mousePressed(MouseEvent e) {
        fd = new FileDialog(new Frame(), "Select Image File", 0);
        fd.setVisible(true);
        String fname = fd.getFile();
        if (fname == null)
            return;
        String fdir = fd.getDirectory();
        im = Toolkit.getDefaultToolkit().getImage(fdir + fname);
        repaint();
        mp.setImageState(index);
        if (index == 1)
            mp.makeSmallImageFrame(im);

        // if second image
        //if (index==1)
        //	mp.initPoint();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}