package ip.apurva;

import ip.gui.frames.ImageFrame;
import ip.gui.frames.XformFrame;
import math.Mat3;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class MorphLog implements ActionListener {
    String titles[] = {"Width of Frame",
                       "Height of Frame",
                       "Number of Frames",
                       "File Name"};
    String defaults[] = {"128", "128", "10",
                         "AnimateFrame"};
    RotationDialog Elog = new RotationDialog(
            new Frame(),
            "Mesh and Cross fade",
            titles,
            defaults,
            50);
    ip.gui.frames.AnimateFrame af = new ip.gui.frames.AnimateFrame();
    XformFrame loadimage1 = new XformFrame(
            "Image 1");
    XformFrame loadimage2 = new XformFrame(
            "Image 2");
    AnimateFrame mg;

    String ImagePic1, ImagePic2;
    int w = 0;
    int h = 0;
    int no_of_frames = 0;
    String filename = new String();

    MorphLog() {

        Elog.Image1.addActionListener(this);
        Elog.Image2.addActionListener(this);
        Elog.setButton.addActionListener(this);
        Elog.Play.addActionListener(this);
        af.setVisible(true);
        mg = new AnimateFrame(af);
        mg.setSize(100, 100);
        mg.setVisible(true);
        //mg.init();

    }

    public static void main(String args[]) {
        new MorphLog();
    }

    public void display() {
        Elog.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {

        Button b = (Button) e.getSource();
        if (b == Elog.setButton) {

            String s[] = Elog.getUserInput();
            w = Integer.parseInt(s[0]);
            h = Integer.parseInt(s[1]);
            no_of_frames =
            Integer.parseInt(s[2]);
            filename = s[3];
            Mat3 at = new Mat3();
            Dimension d = new Dimension();
            d = loadimage1.getSize();
            double xscale, yscale;
            xscale = (w / d.width) * 100;
            yscale = (h / d.height) * 100;
            System.out.println(
                    "" + w + " " + h + " " +
                    d.width +
                    " " +
                    d.height +
                    "" +
                    " " +
                    xscale +
                    " " +
                    yscale +
                    "");
            System.out.println(
                    xscale + " " + yscale + "");
            at.setScale(xscale, yscale);
            // loadimage1.xform(at);
            // loadimage2.xform(at);
            // loadimage1.setSize(w,h);
            // loadimage2.setSize(w,h);
            loadimage1.image2Short();
            loadimage2.image2Short();
            short diffarr[][] = new short[loadimage1.getImageWidth()][loadimage1.getImageHeight()];
            short diffarb[][] = new short[loadimage1.getImageWidth()][loadimage1.getImageHeight()];
            short diffarg[][] = new short[loadimage1.getImageWidth()][loadimage1.getImageHeight()];
            ImageFrame frame = loadimage2;
            for (int i = 0; i <
                            frame.shortImageBean.getR()
                    .length; i++) {
                ImageFrame frame1 = loadimage2;
                for (int j = 0; j <
                                frame1.shortImageBean.getR()[0].length; j++) {
                    ImageFrame frame2 = loadimage2;
                    diffarr[i][j] =
                    (short) ((frame2.shortImageBean.getR()[i][j] -
                              loadimage1.shortImageBean.getR()[i][j]) /
                             no_of_frames);
                    ImageFrame frame4 = loadimage2;
                    diffarb[i][j] =
                    (short) ((frame4.shortImageBean.getB()[i][j] -
                              loadimage1.shortImageBean.getB()[i][j]) /
                             no_of_frames);
                    ImageFrame frame3 = loadimage2;
                    diffarg[i][j] =
                    (short) ((frame3.shortImageBean.getG()[i][j] -
                              loadimage1.shortImageBean.getG()[i][j]) /
                             no_of_frames);
                }
            }
            af.addImage(loadimage1.getImage());
            af.addImage(loadimage2.getImage());

//			loadimage1.saveAsGif(""+filename+"0.ip.gif");
//			loadimage2.saveAsGif(""+filename+""+(no_of_frames-1)+".ip.gif");
            System.out.println(
                    "" + filename + "0.ip.gif");
            loadimage2 = loadimage1;
            for (int i = 1; i < no_of_frames - 1; i++) {
                ImageFrame frame1 = loadimage2;
                for (int j = 0; j <
                                frame1.shortImageBean.getR()
                        .length; j++) {
                    ImageFrame frame2 = loadimage2;
                    for (int k = 0; k <
                                    frame2.shortImageBean.getR()[0].length; k++) {
                        ImageFrame frame3 = loadimage2;
                        ImageFrame frame4 = loadimage2;
                        frame3.shortImageBean.getR()[j][k] =
                        (short) (frame4.shortImageBean.getR()[j][k] +
                                 diffarr[j][k]);
                        ImageFrame frame7 = loadimage2;
                        ImageFrame frame8 = loadimage2;
                        frame7.shortImageBean.getB()[j][k] =
                        (short) (frame8.shortImageBean.getB()[j][k] +
                                 diffarb[j][k]);
                        ImageFrame frame5 = loadimage2;
                        ImageFrame frame6 = loadimage2;
                        frame5.shortImageBean.getG()[j][k] =
                        (short) (frame6.shortImageBean.getG()[j][k] +
                                 diffarg[j][k]);
                    }
                }
                loadimage2.short2Image();
                af.addImage(
                        loadimage2.getImage());
//			loadimage2.saveAsGif(""+filename+i+".ip.gif");
                System.out.println(
                        "" + filename + i +
                        ".ip.gif");
            }
            System.out.println(
                    "" + filename + "" +
                    (no_of_frames - 1) +
                    ".ip.gif");

        }

        if (b == Elog.Image1) {
            FileDialog fd = new FileDialog(
                    new Frame(),
                    "Open Image # 1");
            fd.setVisible(true);
            ImagePic1 = fd.getDirectory() +
                        fd.getFile();
            loadimage1.openGif(ImagePic1);
            fd.dispose();
        }
        if (b == Elog.Image2) {
            FileDialog fd = new FileDialog(
                    new Frame(),
                    "Open Image # 2");
            fd.setVisible(true);
            ImagePic2 = fd.getDirectory() +
                        fd.getFile();
            loadimage2.openGif(ImagePic2);
            fd.dispose();
        }
        if (b == Elog.Play) {
            af.setRunning(true);
/*AnimateFrame af = new AnimateFrame();
      String files[]=new String [no_of_frames];
      System.out.println(filename);
      for(int j=0;j<no_of_frames;j++){
          files[j]=""+filename+j+".ip.gif";
          System.out.println(files[j]);
          }

      af.setSize(loadimage1.r.length,loadimage1.r[0].length);
      Toolkit tk = Toolkit.getDefaultToolkit();
      for (int i=0; i < files.length; i++) {
      Image img = tk.getImage(files[i]);
      waitForImage(new Frame(), img);
      af.addImage(img);
      if ((i % 100) == 0) {
      System.out.println("read file "+i);
              }
              }
          af.setVisible(true);
      */
        }
    }

    static void waitForImage(Component component,
                             Image image) {
        MediaTracker tracker = new MediaTracker(
                component);
        try {
            tracker.addImage(image, 0);
            tracker.waitForID(0);
            if (!tracker.checkID(0))
                System.out.println(
                        "Load failure!");
        } catch (InterruptedException e) {
        }
    }
}
