/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Feb 24, 2004
 * Time: 1:13:09 PM
 * To change this template use Options | File Templates.
 */
package gui.run;

import utils.StringUtils;

import javax.swing.*;

public class ShortcutUtils {
    public static final char META_CHARACTER = '[';
    public static final char LEFT_BRACE = '{';
    public static final char RIGHT_BRACE = '}';

    /**
     * returns true if there is a left and right brace in the label.
     *
     * @param s
     * @return
     */
    public static boolean hasAccelerator(String s) {
        int i1 = s.indexOf(LEFT_BRACE);
        int i2 = s.indexOf(RIGHT_BRACE);
        if (i1 == -1 || i2 == -1) return false;
        return true;
    }

    /**
     * returns true if there is no META_CHARACTER '[' and no
     * KEYSTRING_START and no KEYSTRING_END. E.g. no "{...}" pair.
     *
     * @param s
     * @return
     */
    public static boolean hasShortcut(String s) {
        int i1 = s.indexOf(META_CHARACTER);
        int i2 = s.indexOf(LEFT_BRACE);
        int i3 = s.indexOf(RIGHT_BRACE);
        if (i1 == -1 &&
                ((i2 == -1) || (i3 == -1)))
            return false;
        return true;
    }

    /**
     * return the char next to the '['
     *
     * @param s
     * @return
     */
    public static char getMnemonicChar(String s) {
        if (-1 == s.indexOf(META_CHARACTER))
            return ' ';
        int i1 = s.indexOf(META_CHARACTER);
        return s.charAt(i1 + 1);
    }

    /**
     * get the embedded keyboard accelerator string.
     * This is typically surrounded with '{}''s
     *
     * @param s
     * @return
     */
    public static String getAcceleratorString(String s) {
        if (!hasAccelerator(s)) return "";
        String s1 = s.substring(s.indexOf(LEFT_BRACE) + 1,
                        s.indexOf(RIGHT_BRACE));
        int spaceBeforeChar = s1.lastIndexOf(' ');

        String metaString = s1.substring(0,spaceBeforeChar);

        String characterUpperCased = s1.substring(spaceBeforeChar).toUpperCase();
        return metaString+
                        characterUpperCased;
    }

    /**
     * get the key stroke that corresponds to the give keyboard
     * accelerator.
     *
     * @param s
     * @return
     */
    public static KeyStroke getKeyStroke(String s) {
        return KeyStroke.getKeyStroke(getAcceleratorString(s));
    }

    /**
     * Strip the meta character '[' and return the remaining string
     *
     * @param s
     * @return
     */
    public static String stripMnemonicMetaChar(String s) {
        String newString =
                StringUtils.replaceFirstInstance(s,
                        META_CHARACTER + "",
                        "");
        return
                newString;
    }

    /**
     * remote the left brace from the string and make upper case.
     *
     * @param s
     * @return
     */
    public static String stripAcceleratorString(String s) {
        if (!hasAccelerator(s))
            return s;
        int i = s.indexOf(LEFT_BRACE);
        // since lower case accelerators are not being
        // used, map to upper-case
        return s.substring(0, i).toUpperCase();
    }

    /**
     * Print the <code>Object</code>. This is often commented
     * out for production purpose
     *
     * @param o
     */
    public static void print(Object o) {
        //System.out.println(o);
    }

    /**
     * This was supposed to search the tab list and add mnemonics, but, for
     * some reason, it does not work. This is the bug 4624207
     * http://developer.java.sun.com/developer/bugParade/bugs/4624207.html
     * and it was fixed in 1.5
     *
     * @param jtp
     */
    public static void addShortcut(JTabbedPane jtp) {
        int n = jtp.getTabCount();
        for (int i = 0; i < n; i++) {
            String s = jtp.getTitleAt(i);
            if (!hasShortcut(s)) continue;
            jtp.setMnemonicAt(i,
                    java.awt.event.KeyEvent.VK_1);
            jtp.setTitleAt(i,
                    stripMnemonicMetaChar(s));
        }

    }

    /**
     * "this is a shortcut [c" "this has no shortcut [" "this has no
     * shortcut either"
     *
     * @param ab
     */
    public static void addShortcut(AbstractButton ab) {
        addMnemonic(ab);
        addAccelerator(ab);
    }

    /**
     * add a short-cut to a text field so you can tab over to the field
     *
     * @param tf
     */
    public static void addShortcut(JTextField tf) {
        addFocusAccelerator(tf);
    }

    /**
     * add a short cut to a label so that you can tab over to the corresponding
     * text field. It is for display, only.
     *
     * @param tf
     */
    public static void addShortcut(JLabel tf) {
        String s = tf.getText();
        if (!hasMnemonic(s)) return;
        tf.setDisplayedMnemonic(getMnemonicChar(s));
        tf.setText(stripMnemonicMetaChar(s));
        tf.setToolTipText(tf.getText());
    }

    /**
     * Adds the accelerator without altering textfield contents. This does
     * NOT alter the appearance of the textfield, it only sets the
     * accelerator. Also, the <code>label</code> is used as the tool tip
     * text.
     *
     * @param label label upon which accelerator is based.
     * @param tf    textfield to which accelerator is to be added.
     */
    public static void addFocusAccelerator(String label, JTextField tf) {
        if (!hasMnemonic(label)) return;
        final char mnemonicChar = getMnemonicChar(label);
        tf.setFocusAccelerator(mnemonicChar);
        tf.setToolTipText(stripMnemonicMetaChar(label));
    }

    /**
     * add focus accelerator to a textfield, this will enable you
     * to alt over to the text field in a complex form
     *
     * @param tf
     */
    private static void addFocusAccelerator(JTextField tf) {
        String s = tf.getText();
        if (!hasMnemonic(s)) return;
        tf.setFocusAccelerator(getMnemonicChar(s));
        tf.setText(stripMnemonicMetaChar(s));
        tf.setToolTipText(tf.getText());
    }

    /**
     * add a mnemonic to any abstractbutton (typically a button or
     * a menu or menuitem
     *
     * @param ab
     */
    private static void addMnemonic(AbstractButton ab) {
        String s = ab.getText();
        if (!hasMnemonic(s)) return;
        ab.setMnemonic(getMnemonicChar(s));
        ab.setText(stripMnemonicMetaChar(s));
    }

    /**
     * add an accerlator to a menu item. You can't have accerlators for
     * JButtons.
     *
     * @param ab
     */
    private static void addAccelerator(AbstractButton ab) {
        if (ab instanceof JMenuItem)
            addAccelerator((JMenuItem) ab);
    }

    /**
     * test for the mnemonic '[' in a string
     *
     * @param s
     * @return
     */
    private static boolean hasMnemonic(String s) {
        int mc = s.indexOf(META_CHARACTER);
        if (-1 == mc)
            return false;
        if (s.length() == mc - 1) return false;
        return true;
    }

    /**
     * Accelerator strings are embedded in the label of a JMenuItem. For
     * example: "my label{alt shift X} "another label {control DELETE}
     * works on JCheckBoxMenuItem and JRadioButtonMenuItem
     *
     * @param jmi
     */
    public static void addAccelerator(JMenuItem jmi) {
        print("Adding accelerator");
        String s = jmi.getText();
        print(s);
        testString(s);
        if (!hasAccelerator(s)) return;

        jmi.setAccelerator(getKeyStroke(s));
        jmi.setText(stripAcceleratorString(s));
    }

    public static void main(String args[]) {
        String s = "this is a [test{alt shift X}";
        testString(s);
    }

    private static void testString(String s) {
        print(s);
        print("stripChar=" +
                stripMnemonicMetaChar(s));
        print("The shortcut char=" +
                getMnemonicChar(s));
        print("hasKeyString=" +
                hasAccelerator(s));
        print("keyString=" +
                getAcceleratorString(s));
        print("keyStroke=" +
                KeyStroke.getKeyStroke(getAcceleratorString(s)));
        print("stripKeyString=" +
                stripAcceleratorString(s));
    }
}
