/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.run;

import gui.ClosableJFrame;
import gui.layouts.DialogLayout;

import javax.swing.*;
import javax.vecmath.Vector3d;
import java.awt.*;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 9, 2005
 * <p/>
 * Time: 7:34:44 AM
 */
public abstract class RunVec3dPanel extends JPanel implements Runnable {
    private SpinnerNumberModel xNm = new SpinnerNumberModel(
            0,
            -100,
            100,
            1);
    private SpinnerNumberModel yNm = new SpinnerNumberModel(
            0,
            -100,
            100,
            1);
    private SpinnerNumberModel zNm = new SpinnerNumberModel(
            0,
            -100,
            100,
            1);

    public RunVec3dPanel() {
        initSliders();
    }
    public SpinnerNumberModel[] getModel(){
        SpinnerNumberModel spa[]=  {xNm,yNm,zNm};
        return spa;
    }

    /**
     * Call initSliders if you have
     * reset the number models
     */
    public void initSliders() {
        setLayout(new DialogLayout());
        add(new JLabel("x"));
        add(
                new RunSpinnerSlider(xNm) {
                    public void run() {
                        xNm.setValue(new Integer(getValue()));
                        RunVec3dPanel.this.run();
                    }
                });
        add(new JLabel("y"));

        add(
                new RunSpinnerSlider(yNm) {
                    public void run() {
                        yNm.setValue(new Integer(getValue()));
                        RunVec3dPanel.this.run();
                    }
                });
        add(new JLabel("z"));

        add(
                new RunSpinnerSlider(zNm) {
                    public void run() {
                        zNm.setValue(new Integer(getValue()));
                        RunVec3dPanel.this.run();
                    }
                });
    }

    public Vector3d getValue() {
        return new Vector3d(
                getValue(xNm) / 100.0,
                getValue(yNm) / 100.0,
                getValue(zNm) / 100.0);
    }
    private final int getValue(SpinnerNumberModel nm) {
        return ((Integer) nm.getValue()).intValue();
    }
    public static void test() {

        ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        RunVec3dPanel runVec3dPanel = new RunVec3dPanel() {
                    public void run() {
                        Vector3d value = getValue();
                        System.out.println(value);
                    }
                };
        c.add(runVec3dPanel);
        runVec3dPanel.setxNm(new SpinnerNumberModel(0,0,360,1));
        runVec3dPanel.setyNm(new SpinnerNumberModel(0, 0, 360, 1));
        runVec3dPanel.setzNm(new SpinnerNumberModel(0, 0, 360, 1));
        runVec3dPanel.initSliders();
        c.setLayout(new FlowLayout());
        cf.setSize(400, 400);
        cf.setVisible(true);

    }

    public static void main(String[] args) {

        ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        c.add(new RunVec3dPanel(){
            public void run(){
                Vector3d value = getValue();
                System.out.println(value);
            }
        });
        c.setLayout(new FlowLayout());
        cf.setSize(400, 400);
        cf.setVisible(true);

    }

    public SpinnerNumberModel getxNm() {
        return xNm;
    }

    public void setxNm(SpinnerNumberModel xNm) {
        this.xNm = xNm;
    }

    public SpinnerNumberModel getyNm() {
        return yNm;
    }

    public void setyNm(SpinnerNumberModel yNm) {
        this.yNm = yNm;
    }

    public SpinnerNumberModel getzNm() {
        return zNm;
    }

    public void setzNm(SpinnerNumberModel zNm) {
        this.zNm = zNm;
    }
}
