package gui.run;


import gui.ClosableJFrame;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * Use the adapter design patter to alter the interface from ActionListener
 * to Runnable. Use the command pattern by creating anonymous inner classes
 * to embed implementations of the runnable interface.
 */
public abstract class RunMenuItem extends
        JMenuItem
        implements
        ActionListener, Runnable {


    public RunMenuItem(String label) {
        this(label, null);
    }

    public RunMenuItem(String l, Icon i) {
        super(l, i);
        addActionListener(this);
        ShortcutUtils.addShortcut(this);
    }

    public RunMenuItem(Icon i) {
        this(null, i);
    }

    public RunMenuItem() {
        this(null, null);
    }

    public void actionPerformed(ActionEvent e) {
        run();
    }

    public static void main(String args[]) {
        ClosableJFrame cf = new ClosableJFrame("RunMenuItem");
        Container c = cf.getContentPane();
        c.add(new RunButton("ok"){
            public void run(){
                System.out.println("ok");
            }
        });
        cf.setJMenuBar(getMenuBar());
        c.setLayout(new java.awt.FlowLayout());
        cf.setSize(200, 200);
        cf.setVisible(true);
    }

    public static JMenuBar getMenuBar() {
        RunMenuBar mb = new RunMenuBar();
        mb.add(getFileMenu());
        mb.add(getEditMenu());
        return mb;
    }

//    private static void print(Vector v) {
//        for (int i = 0; i < v.size(); i++) {
//            RunMenuItem rmi = ((RunMenuItem) v.elementAt(i));
//            System.out.print("rmi=" + rmi.getText());
//            System.out.println("\tgetAccelerator=" + rmi.getAccelerator().toString());
//        }
//    }

    public static RunMenu getDrawMenu() {
        RunMenu drawMenu = new RunMenu("[draw");
        drawMenu.add(new RunMenuItem("[rect{alt shift R}") {
            public void run() {
                System.out.println(getText());
            }
        });
        drawMenu.add(new RunMenuItem("[circle{alt shift C}") {
            public void run() {
                System.out.println(getText());
            }
        });
        drawMenu.add(new RunMenuItem("r[ect2{alt R}") {
            public void run() {
                System.out.println(getText());
            }
        });
        drawMenu.add(new RunMenuItem("[square{shift F12}") {
            public void run() {
                System.out.println(getText());
            }
        });
        drawMenu.add(new RunMenuItem("[quad{alt 1}") {
            public void run() {
                System.out.println(getText());
            }
        });
        drawMenu.add(new RunMenuItem("r[ight arrow{alt RIGHT}") {
            public void run() {
                System.out.println(getText());
            }
        });
        drawMenu.add(new RunMenuItem("[fat line{ctrl alt shift L}") {
            public void run() {
                System.out.println(getText());
            }
        });
   
        return drawMenu;
    }

    public static RunMenu getEditMenu() {
        RunMenu editMenu = new RunMenu("[Edit");
        editMenu.add(new RunMenuItem("[Undo{control DELETE}") {
            public void run() {
                System.out.println(getText());
            }
        });
        editMenu.add(new RunMenuItem("Sill[y Thing{control Q}") {
            public void run() {
                System.out.println(getText());
            }
        });
        editMenu.add(new RunMenuItem("[cut{control shift C}") {
            public void run() {
                System.out.println(getText());
            }
        });
        editMenu.add(getDrawMenu());
        return editMenu;
    }

    public static RunMenu getFileMenu() {
        RunMenu fileMenu = new RunMenu("[File");
        fileMenu.add(new RunMenuItem("[open{alt shift X}") {
            public void run() {
                System.out.println(getText());
            }
        });
        fileMenu.add(new RunMenuItem("[save{alt control DELETE}") {
            public void run() {
                System.out.println(getText());
            }
        });
        return fileMenu;
    }

}