package gui.run;

import gui.In;

import javax.swing.*;
import java.awt.*;
import java.util.Vector;

/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Jan 25, 2005
 * Time: 1:15:22 PM
 * Copyright DocJava, Inc., 2005
 */
public class RunMenuBar extends JMenuBar {
    /**
     * construct a RunMenuBar just like any other, just
     * check for duplicate accelerators.
     */
    public RunMenuBar() {
        super();
    }

    public void add(RunMenu runMenu) {
        super.add(runMenu);
        testMenuBar(this);
    }

    private static void testMenuBar(JMenuBar mb) {
        Vector v = new Vector();
        int noi = mb.getMenuCount();
        for (int i = 0; i < noi; i++) {
            RunMenu jm = (RunMenu) mb.getMenu(i);
            addMenuComponents(jm, v);
        }
        checkForDupAccelerators(v);

    }

    private static void checkForDupAccelerators(Vector v) {
        Vector al = new Vector();
        for (int i = 0; i < v.size(); i++) {
            RunMenuItem rmi = ((RunMenuItem) v.elementAt(i));
            if (rmi==null) return;
            KeyStroke accelerator = rmi.getAccelerator();
            if (accelerator == null) return;
            if (al.contains(accelerator)) {
                In.message("warning, duplicated Accelerator detected:" + rmi.getText() +
                        ":" + accelerator.toString());
            }
            al.addElement(accelerator);
            //System.out.println("\tgetAccelerator=" + accelerator.toString());
        }
    }

    private static void addMenuComponents(RunMenu jm, Vector v) {
        int nomc = jm.getMenuComponentCount();
        for (int j = 0; j < nomc; j++) {
            Component c = jm.getMenuComponent(j);
            if (c instanceof RunMenuItem) {
                v.add(c);
            } else if (c instanceof RunMenu) {
                addMenuComponents((RunMenu) c, v);
            }

        }
    }
}
