/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.run;

import gui.ClosableJFrame;

import javax.swing.*;
import javax.vecmath.Matrix3d;
import java.awt.*;


public abstract class RunMatrix3dPanel extends
        JPanel implements
        Runnable {
    private Matrix3d m3d = new Matrix3d();

    public Matrix3d getValue() {
        return m3d;
    }

    RunVec3dPanel rvpCol1 = new RunVec3dPanel() {
        public void run() {
            m3d.setColumn(0, getValue());
            RunMatrix3dPanel.this.run();
        }
    };
    RunVec3dPanel rvpCol2 = new RunVec3dPanel() {
        public void run() {
            m3d.setColumn(1, getValue());
            RunMatrix3dPanel.this.run();
        }
    };
    RunVec3dPanel rvpCol3 = new RunVec3dPanel() {
        public void run() {
            m3d.setColumn(2, getValue());
            RunMatrix3dPanel.this.run();
        }
    };

    public SpinnerNumberModel[][] getModel() {
        SpinnerNumberModel snm[][]={
           rvpCol1.getModel(),
           rvpCol2.getModel(),
           rvpCol3.getModel()
        };
       return snm;
    }

    public RunMatrix3dPanel() {
        setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();

        tabbedPane.addTab("col1", rvpCol1);

        tabbedPane.addTab("col2", rvpCol2);

        tabbedPane.addTab("col3", rvpCol3);

        add(BorderLayout.CENTER, tabbedPane);


    }


    public static void main(String[] args) {

        ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        final Matrix3dView view = new Matrix3dView();
        c.add(new RunMatrix3dPanel() {
            public void run() {
                view.updateView(getValue());
            }
        });

        c.add(view);
        c.setLayout(new FlowLayout());
        cf.setSize(400, 400);
        cf.setVisible(true);

    }

}
