/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.run;


import gui.ClosableJFrame;
import gui.layouts.DialogLayout;

import javax.swing.*;
import java.awt.*;


public abstract class RunDialPanel
        extends JPanel implements Runnable {

    private DialBean dialBean = DialBean.restore();



    public RunDialPanel() {

        init();
    }

    private void init() {
        setLayout(new BorderLayout());
        add(getDialPanel(), BorderLayout.CENTER);
        add(getButtonPanel(), BorderLayout.SOUTH);

    }

    private JPanel getDialPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new DialogLayout());

        jp.add(new JLabel("calling card:"));
        jp.add(
                new RunTextField(dialBean.getCallingCardNumber()) {
                    public void run() {
                        dialBean.setCallingCardNumber(getText());
                    }
                });

        final JLabel toneDialLabel = new JLabel("Tone:");
        jp.add(toneDialLabel);
        jp.add(
                new RunCheckBox(dialBean.isToneDial()) {
                    public void run() {
                        dialBean.setToneDial(isSelected());
                        if (isSelected())
                            toneDialLabel.setText("Tone:");
                        else
                            toneDialLabel.setText("pulse:");
                    }
                });
        jp.add(new JLabel("TT speed(ms)"));
        final SpinnerNumberModel sm = new SpinnerNumberModel(
                dialBean.getSpeed(),
                65,
                255,
                5);
        jp.add(
                new RunSpinnerSlider(sm) {
                    public void run() {
                        dialBean.setSpeed(getValue());
                    }
                });

        final JLabel mdl = getDialLabel();
        jp.add(mdl);
        jp.add(
                new RunCheckBox(dialBean.isModemDial()) {
                    public void run() {
                        dialBean.setModemDial(isSelected());
                        if (isSelected())
                            mdl.setText("Modem dial:");
                        else {
                            mdl.setText("Speaker Dial:");
                        }
                    }
                });
        return jp;
    }

    public final JLabel getDialLabel() {
        if (dialBean.isModemDial()) return new JLabel("Modem dial:");
        return new JLabel("Speaker Dial:");
    }

    public DialBean getValue() {
        return dialBean;
    }


    private JPanel getButtonPanel() {
        JPanel jp = new JPanel();

        jp.setLayout(new FlowLayout());
        final RunButton runButton = new RunButton("ok") {
            public void run() {
                doOk();
            }
        };
        jp.add(runButton);
        runButton.setEnabled(true);
        return jp;
    }

    private void doOk() {
        dialBean.save();
        //spu.setDtmfSpeed(dialBean.getSpeed());
        this.run();
    }


    public static void main(String[] args) {
        final ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        c.add(
                new RunDialPanel() {
                    public void run() {
                        System.out.println(getValue());
                        cf.pack();
                    }
                });
        cf.pack();
        cf.setVisible(true);
    }


}