package gui.run;

import gui.In;

import javax.swing.*;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.*;

/**
 * Copyright DocJava, inc. User: lyon Date: Oct 1, 2004 Time: 2:38:45 AM
 */
public abstract class RunColorChooser
        extends
        JColorChooser
        implements Runnable, ChangeListener {
    private Color selectedColor = getColor();
    private ColorSelectionModel csm =
            getSelectionModel();

    public RunColorChooser() {

        csm.addChangeListener(this);
    }

    public static void main(String[] args) {
        In.message("you selected:" +
                RunColorChooser.getColorAtomic());

    }

    public static Color getColorAtomic() {
        final JDialog jd = new JDialog();
        Container c = jd.getContentPane();
        final RunButton okButton = new RunButton("ok") {
            public void run() {
                jd.setVisible(false);
            }
        };
        c.add(okButton);
        RunColorChooser rcc = new RunColorChooser() {
            public void run() {
                okButton.setBackground(getSelectedColor());
            }
        };
        c.add(rcc);
        c.setLayout(new FlowLayout());
        jd.setModal(true);
        jd.pack();
        jd.setVisible(true);
        return rcc.getColor();
    }


    public void stateChanged(ChangeEvent e) {
        selectedColor = csm.getSelectedColor();
        run();
    }

    public Color getSelectedColor() {
        return selectedColor;
    }

    public void setSelectedColor(Color selectedColor) {
        this.selectedColor = selectedColor;
        super.setColor(selectedColor);
    }
}
