package gui.run;

import java.util.Observable;

public class ObservableFloat extends Observable {

    private float value = 0;

    public synchronized void setValue(float newValue) {
        if (newValue != value) {
            value = newValue;
            super.setChanged();
            super.notifyObservers(this);
        }
    }

    public synchronized float getValue() {
        return value;
    }
}